/*
 * Decompiled with CFR 0.152.
 */
package com.wedomo.halo.plugin.testes;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakImage;
import com.wedomo.halo.plugin.PakReader;
import com.wedomo.halo.plugin.PakString;
import com.wedomo.halo.plugin.PakUnknown;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;

public class AncientEmpireReader
implements PakReader {
    private static final String PLUGIN_NAME = "AncientEmpire";
    private String fileName;

    public Pak readPak(String filename) throws Exception {
        this.fileName = filename;
        return this.readPak(new FileInputStream(filename));
    }

    public Pak readPak(InputStream in) throws Exception {
        Pak ret = null;
        ret = new Pak();
        DataInputStream datainputstream = new DataInputStream(in);
        if (this.fileName.endsWith(".pak")) {
            int unknown = datainputstream.readInt();
            int size = datainputstream.readInt();
            String[] _img_name = new String[size / 32];
            int[] _img_start_pos = new int[size / 32];
            int[] _img_content_capability = new int[size / 32];
            byte[] imgName = new byte[24];
            int unitLength = 0;
            int idx = 0;
            while (unitLength < size) {
                unitLength += 32;
                datainputstream.readFully(imgName);
                _img_name[idx] = new String(imgName).trim();
                _img_start_pos[idx] = datainputstream.readInt();
                _img_content_capability[idx] = datainputstream.readInt();
                PakString pakString = new PakString(_img_name[idx]);
                ret.addObject((Object)pakString);
                ++idx;
            }
            ret.addBreakPoint((Object)new Integer(ret.getObjects().size()));
            idx = 0;
            while (idx < _img_name.length) {
                PakImage pakObject;
                byte[] result = new byte[_img_content_capability[idx]];
                datainputstream.readFully(result);
                if (_img_name[idx].endsWith(".png")) {
                    pakObject = new PakImage(result, 0);
                    pakObject.setName(_img_name[idx]);
                } else if (_img_name[idx].endsWith(".sprite")) {
                    pakObject = new PakUnknown(result);
                    pakObject.setName(_img_name[idx]);
                    pakObject.setDescription("\u7cbe\u7075\u6587\u4ef6");
                } else {
                    pakObject = new PakUnknown(result);
                    pakObject.setName(_img_name[idx]);
                    pakObject.setDescription("Unknown File");
                }
                ret.addObject((Object)pakObject);
                ++idx;
            }
        } else {
            int num = datainputstream.readInt();
            int i = 0;
            while (i < num) {
                PakString pakString = new PakString(datainputstream.readUTF());
                ret.addObject((Object)pakString);
                ++i;
            }
        }
        datainputstream.close();
        return ret;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getDescription() {
        return "Ancient Empire Reader";
    }
}

