/*
 * Decompiled with CFR 0.152.
 */
package com.wedomo.halo.plugin.testes;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakImage;
import com.wedomo.halo.plugin.PakString;
import com.wedomo.halo.plugin.PakWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class AncientEmpireWriter
implements PakWriter {
    private static final String PLUGIN_NAME = "AncientEmpire";
    private String fileName;

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getDescription() {
        return "Ancient Empire Writer";
    }

    public void writePak(Pak pak, String filename) throws Exception {
        this.fileName = filename;
        this.writePak(pak, new FileOutputStream(filename));
    }

    public void writePak(Pak pak, OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Vector objects = pak.getObjects();
        if (this.fileName.endsWith(".dat")) {
            dos.writeInt(objects.size());
            int i = 0;
            while (i < objects.size()) {
                PakString ps = (PakString)objects.get(i);
                dos.writeUTF(ps.getText());
                ++i;
            }
        } else {
            dos.writeInt(0);
            int numOfRes = (Integer)pak.getBreakPoint(0);
            int pointer = 8 + 32 * numOfRes;
            int i = 0;
            while (i < numOfRes) {
                PakString ps = (PakString)objects.get(i);
                PakImage pi = (PakImage)objects.get(numOfRes + i);
                byte[] temp = new byte[24];
                byte[] textBytes = ps.getText().getBytes();
                System.arraycopy(textBytes, 0, temp, 0, textBytes.length);
                dos.writeInt(pointer);
                dos.writeInt(pi.getLength().intValue());
                pointer += pi.getLength().intValue();
                ++i;
            }
            i = numOfRes;
            while (i < objects.size()) {
                PakImage pi = (PakImage)objects.get(i);
                dos.write((byte[])pi.getImage());
                ++i;
            }
        }
        dos.close();
        baos.writeTo(out);
    }
}

