/*
 * Decompiled with CFR 0.152.
 */
package com.wedomo.halo.plugin.testes;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakString;
import com.wedomo.halo.plugin.PakWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class GloftLOSTWriter
implements PakWriter {
    private static final String PLUGIN_NAME = "GameLoft Lost";

    public void writePak(Pak pak, String filename) throws Exception {
        this.writePak(pak, new FileOutputStream(filename));
    }

    public void writePak(Pak pak, OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Vector objects = pak.getObjects();
        ByteArrayOutputStream strBaos = new ByteArrayOutputStream();
        ByteArrayOutputStream offBaos = new ByteArrayOutputStream();
        DataOutputStream offDis = new DataOutputStream(offBaos);
        offDis.write(GloftLOSTWriter.short2bytes((short)objects.size()));
        int count = 0;
        int j = 0;
        while (j < objects.size()) {
            PakString ps = (PakString)objects.get(j);
            if (!ps.getText().equals("")) {
                byte[] bytes = ps.getText().getBytes("UTF-8");
                byte[] data = new byte[bytes.length + 1];
                System.arraycopy(bytes, 0, data, 0, bytes.length);
                strBaos.write(data);
                offDis.write(GloftLOSTWriter.short2bytes((short)(count += data.length)));
            } else {
                byte[] tmp = new byte[1];
                strBaos.write(tmp);
                offDis.write(GloftLOSTWriter.short2bytes((short)(count += tmp.length)));
            }
            ++j;
        }
        dos.write(GloftLOSTWriter.short2bytes((short)3));
        dos.write(GloftLOSTWriter.int2bytes(0));
        dos.write(GloftLOSTWriter.int2bytes(strBaos.toByteArray().length));
        dos.write(GloftLOSTWriter.int2bytes(strBaos.toByteArray().length + offBaos.toByteArray().length));
        dos.write(strBaos.toByteArray());
        dos.write(offBaos.toByteArray());
        dos.close();
        baos.writeTo(out);
    }

    static byte[] int2bytes(int x) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)x;
            x >>= 8;
            ++i;
        }
        return b;
    }

    static byte[] short2bytes(short x) {
        byte[] b = new byte[2];
        int i = 0;
        while (i < b.length) {
            b[i] = (byte)x;
            x = (short)(x >> 8);
            ++i;
        }
        return b;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getDescription() {
        return null;
    }
}

