/*
 * Decompiled with CFR 0.152.
 */
package com.wedomo.halo.plugin.testes;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakImage;
import com.wedomo.halo.plugin.PakString;
import com.wedomo.halo.plugin.PakWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class HolyWars_Writer
implements PakWriter {
    private static final String PLUNIN_NAME = "HolyWars";
    private String fileName;

    public void writePak(Pak pak, String filename) throws Exception {
        this.fileName = filename;
        this.writePak(pak, new FileOutputStream(filename));
    }

    public void writePak(Pak pak, OutputStream out) throws Exception {
        PakImage pi;
        byte[] data;
        PakString ps;
        int header;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Vector objects = pak.getObjects();
        dos.write(HolyWars_Writer.int2bytes(objects.size()));
        int count = header = 4 + (objects.size() + 1) * 4;
        dos.write(HolyWars_Writer.int2bytes(count));
        int i = 0;
        while (i < objects.size()) {
            if (this.fileName.endsWith("t")) {
                ps = (PakString)objects.get(i);
                data = this.string2UTF(ps.getText());
                dos.write(HolyWars_Writer.int2bytes(count += data.length));
            } else if (this.fileName.endsWith("i")) {
                pi = (PakImage)objects.get(i);
                data = pi.getImageAsByte();
                dos.write(HolyWars_Writer.int2bytes(count += data.length));
            }
            ++i;
        }
        i = 0;
        while (i < objects.size()) {
            if (this.fileName.endsWith("t")) {
                ps = (PakString)objects.get(i);
                data = this.string2UTF(ps.getText());
                dos.write(data);
            } else if (this.fileName.endsWith("i")) {
                pi = (PakImage)objects.get(i);
                dos.write(pi.getImageAsByte());
            }
            ++i;
        }
        dos.close();
        baos.writeTo(out);
    }

    public String getName() {
        return PLUNIN_NAME;
    }

    public String getDescription() {
        return null;
    }

    static byte[] int2bytes(int x) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            b[i] = (byte)x;
            x >>= 8;
            ++i;
        }
        return b;
    }

    private byte[] string2UTF(String s) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(s);
        dos.close();
        return baos.toByteArray();
    }
}

