/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Util3D;

public class FigureLayout {
    private AffineTrans[] myAffineArray;
    private AffineTrans myAffineNow;
    private int myScaleX;
    private int myScaleY;
    private int myCenterX;
    private int myCenterY;
    private int myParaWidth;
    private int myParaHeight;
    private int myPersNear;
    private int myPersFar;
    private int myPersAngle;
    private int myPersWidth;
    private int myPersHeight;
    private int mySettingIndex;

    private static native void initializeClass0();

    public FigureLayout() {
        this.setAffineTrans((AffineTrans)null);
        this.myScaleX = 512;
        this.myScaleY = 512;
    }

    public FigureLayout(AffineTrans trans, int sx, int sy, int cx, int cy) {
        this.setAffineTrans(trans);
        this.myScaleX = sx;
        this.myScaleY = sy;
        this.myCenterX = cx;
        this.myCenterY = cy;
    }

    public final AffineTrans getAffineTrans() {
        return this.myAffineNow;
    }

    public final void setAffineTrans(AffineTrans trans) {
        if (trans == null) {
            trans = new AffineTrans();
            trans.setIdentity();
        }
        if (this.myAffineArray == null) {
            this.myAffineArray = new AffineTrans[1];
            this.myAffineArray[0] = trans;
        }
        this.myAffineNow = trans;
    }

    public final void setAffineTransArray(AffineTrans[] trans) {
        this.setAffineTrans(trans);
    }

    public final void setAffineTrans(AffineTrans[] trans) {
        if (trans == null || trans.length == 0) {
            throw Util3D.npe;
        }
        for (int i = 0; i < trans.length; ++i) {
            if (trans[i] != null) continue;
            throw Util3D.npe;
        }
        this.myAffineArray = trans;
    }

    public final void selectAffineTrans(int idx) {
        if (this.myAffineArray == null || idx < 0 || idx >= this.myAffineArray.length) {
            throw Util3D.iae;
        }
        this.myAffineNow = this.myAffineArray[idx];
    }

    public final int getScaleX() {
        return this.myScaleX;
    }

    public final int getScaleY() {
        return this.myScaleY;
    }

    public final void setScale(int sx, int sy) {
        this.myScaleX = sx;
        this.myScaleY = sy;
        this.mySettingIndex = 0;
    }

    public final int getParallelWidth() {
        return this.myParaWidth;
    }

    public final int getParallelHeight() {
        return this.myParaHeight;
    }

    public final void setParallelSize(int w, int h) {
        if (w < 0 || h < 0) {
            throw Util3D.iae;
        }
        this.myParaWidth = w;
        this.myParaHeight = h;
        this.mySettingIndex = 1;
    }

    public final int getCenterX() {
        return this.myCenterX;
    }

    public final int getCenterY() {
        return this.myCenterY;
    }

    public final void setCenter(int cx, int cy) {
        this.myCenterX = cx;
        this.myCenterY = cy;
    }

    public final void setPerspective(int zNear, int zFar, int angle) {
        if (zNear >= zFar || zNear < 1 || zNear > 32766 || zFar < 2 || zFar > Short.MAX_VALUE || angle < 1 || angle > 2047) {
            throw Util3D.iae;
        }
        this.myPersNear = zNear;
        this.myPersFar = zFar;
        this.myPersAngle = angle;
        this.mySettingIndex = 2;
    }

    public final void setPerspective(int zNear, int zFar, int width, int height) {
        if (zNear >= zFar || zNear < 1 || zNear > 32766 || zFar < 2 || zFar > Short.MAX_VALUE || width < 0 || height < 0) {
            throw Util3D.iae;
        }
        this.myPersNear = zNear;
        this.myPersFar = zFar;
        this.myPersWidth = width;
        this.myPersHeight = height;
        this.mySettingIndex = 3;
    }

    static {
        FigureLayout.initializeClass0();
    }
}

