/*
 * Decompiled with CFR 0.152.
 */
package plugin.com.reaxion;

import com.wedomo.halo.plugin.Pak;
import com.wedomo.halo.plugin.PakImage;
import com.wedomo.halo.plugin.PakString;
import com.wedomo.halo.plugin.PakUnknown;
import com.wedomo.halo.plugin.PakWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class MIB_Writer
implements PakWriter {
    private static final String PLUGIN_NAME = "Men In Black";

    public void writePak(Pak pak, String filename) throws Exception {
        this.writePak(pak, new FileOutputStream(filename));
    }

    public void writePak(Pak pak, OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Vector objects = pak.getObjects();
        Vector breaks = pak.getBreakPoints();
        dos.writeByte((Integer)breaks.get(0));
        dos.writeByte((Integer)breaks.get(1));
        int count = 0;
        int i = 0;
        i = 2;
        while (i < breaks.size()) {
            int type = (Integer)breaks.get(i);
            dos.writeByte(type);
            switch (type) {
                case 4: {
                    int numOfStrings = (Integer)breaks.get(++i);
                    ByteArrayOutputStream baos_utf = new ByteArrayOutputStream();
                    DataOutputStream dos_utf = new DataOutputStream(baos_utf);
                    dos_utf.writeShort(numOfStrings);
                    int idx = 0;
                    while (idx < numOfStrings) {
                        PakString ps = (PakString)objects.get(count);
                        dos_utf.writeUTF(ps.getText());
                        ++count;
                        ++idx;
                    }
                    dos.writeShort(baos_utf.toByteArray().length);
                    dos.write(baos_utf.toByteArray());
                    dos_utf.close();
                    break;
                }
                case 2: {
                    PakImage pi = (PakImage)objects.get(count);
                    dos.writeShort(pi.getLength().intValue());
                    dos.write(pi.getImageAsByte());
                    ++count;
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    PakUnknown pu = (PakUnknown)objects.get(count);
                    dos.writeShort(pu.getLength().intValue());
                    dos.write(pu.getData());
                    ++count;
                    break;
                }
            }
            ++i;
        }
        dos.close();
        baos.writeTo(out);
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getDescription() {
        return null;
    }

    static byte[] short2bytes(short x) {
        byte[] b = new byte[2];
        int i = b.length - 1;
        while (i > 0) {
            b[i] = (byte)x;
            x = (short)(x >> 8);
            --i;
        }
        return b;
    }

    private byte[] string2UTF(String s) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(s);
        dos.close();
        return baos.toByteArray();
    }
}

