/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import jdk.internal.loader.BuiltinClassLoader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JavaFXPatcher {
    private static final String[] addOpens = new String[]{"javafx.base/com.sun.javafx.runtime", "javafx.base/com.sun.javafx.binding", "javafx.base/com.sun.javafx.event", "javafx.graphics/javafx.css", "javafx.graphics/com.sun.javafx.stage", "javafx.controls/com.sun.javafx.scene.control.behavior", "javafx.controls/javafx.scene.control.skin", "javafx.controls/com.sun.javafx.scene.control"};
    private static final String[] addExports = new String[]{"javafx.base/com.sun.javafx.binding", "javafx.base/com.sun.javafx.event", "javafx.graphics/com.sun.javafx.stage", "javafx.controls/com.sun.javafx.scene.control.behavior", "javafx.controls/javafx.scene.control.skin", "javafx.controls/com.sun.javafx.scene.control"};

    private JavaFXPatcher() {
    }

    public static void patch(Set<String> modules, Path ... jarPaths) throws ReflectiveOperationException {
        ModuleFinder finder = ModuleFinder.of(jarPaths);
        for (ModuleReference mref : finder.findAll()) {
            ((BuiltinClassLoader)ClassLoader.getSystemClassLoader()).loadModule(mref);
        }
        Configuration config = Configuration.resolveAndBind(finder, List.of(ModuleLayer.boot().configuration()), finder, modules);
        ModuleLayer layer = ModuleLayer.defineModules(config, List.of(ModuleLayer.boot()), name -> ClassLoader.getSystemClassLoader()).layer();
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Module.class, MethodHandles.lookup());
            JavaFXPatcher.addExportsOrOpens(addExports, layer, lookup.findVirtual(Module.class, "implAddExportsToAllUnnamed", MethodType.methodType(Void.TYPE, String.class)));
            JavaFXPatcher.addExportsOrOpens(addOpens, layer, lookup.findVirtual(Module.class, "implAddOpensToAllUnnamed", MethodType.methodType(Void.TYPE, String.class)));
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    private static void addExportsOrOpens(String[] targets, ModuleLayer layer, MethodHandle handle) {
        for (String target : targets) {
            String[] name = target.split("/", 2);
            layer.findModule(name[0]).ifPresent(m -> {
                try {
                    handle.invokeWithArguments(m, name[1]);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            });
        }
    }
}

