/*
 * Decompiled with CFR 0.152.
 */
package moe.mickey.minecraft.skin.fx;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javafx.animation.Transition;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;

public class SkinTransition
extends Transition {
    protected Function<Double, Double> expression;
    protected List<WritableValue<Number>> observables;
    protected boolean fix;
    protected int count;

    public int getCount() {
        return this.count;
    }

    public SkinTransition(Duration duration, Function<Double, Double> expression, WritableValue<Number> ... observables) {
        this.setCycleDuration(duration);
        this.expression = expression;
        this.observables = Arrays.asList(observables);
    }

    protected void interpolate(double frac) {
        if (frac == 0.0 || frac == 1.0) {
            ++this.count;
        }
        double val = this.expression.apply(frac);
        this.observables.forEach(w -> w.setValue((Object)val));
    }

    public void play() {
        this.count = 0;
        super.play();
    }
}

