/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.factories;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import org.hildan.fxgson.adapters.properties.ListPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.MapPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.ObjectPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.SetPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.StringPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.BooleanPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.DoublePropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.FloatPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.IntegerPropertyTypeAdapter;
import org.hildan.fxgson.adapters.properties.primitives.LongPropertyTypeAdapter;
import org.hildan.fxgson.factories.TypeHelper;

public class JavaFxPropertyTypeAdapterFactory
implements TypeAdapterFactory {
    private final boolean strictProperties;
    private final boolean strictPrimitives;

    public JavaFxPropertyTypeAdapterFactory() {
        this(true, true);
    }

    public JavaFxPropertyTypeAdapterFactory(boolean throwOnNullProperties, boolean throwOnNullPrimitives) {
        this.strictProperties = throwOnNullProperties;
        this.strictPrimitives = throwOnNullPrimitives;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> clazz = type.getRawType();
        if (!Property.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (BooleanProperty.class.isAssignableFrom(clazz)) {
            return new BooleanPropertyTypeAdapter(gson.getAdapter(Boolean.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (IntegerProperty.class.isAssignableFrom(clazz)) {
            return new IntegerPropertyTypeAdapter(gson.getAdapter(Integer.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (LongProperty.class.isAssignableFrom(clazz)) {
            return new LongPropertyTypeAdapter(gson.getAdapter(Long.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (FloatProperty.class.isAssignableFrom(clazz)) {
            return new FloatPropertyTypeAdapter(gson.getAdapter(Float.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (DoubleProperty.class.isAssignableFrom(clazz)) {
            return new DoublePropertyTypeAdapter(gson.getAdapter(Double.TYPE), this.strictProperties, this.strictPrimitives);
        }
        if (StringProperty.class.isAssignableFrom(clazz)) {
            return new StringPropertyTypeAdapter(gson.getAdapter(String.class), this.strictProperties);
        }
        if (ListProperty.class.isAssignableFrom(clazz)) {
            TypeAdapter delegate = gson.getAdapter(TypeHelper.withRawType(type, ObservableList.class));
            return new ListPropertyTypeAdapter(delegate, this.strictProperties);
        }
        if (SetProperty.class.isAssignableFrom(clazz)) {
            TypeAdapter delegate = gson.getAdapter(TypeHelper.withRawType(type, ObservableSet.class));
            return new SetPropertyTypeAdapter(delegate, this.strictProperties);
        }
        if (MapProperty.class.isAssignableFrom(clazz)) {
            TypeAdapter delegate = gson.getAdapter(TypeHelper.withRawType(type, ObservableMap.class));
            return new MapPropertyTypeAdapter(delegate, this.strictProperties);
        }
        Type[] typeParams = ((ParameterizedType)type.getType()).getActualTypeArguments();
        Type param = typeParams[0];
        TypeAdapter<?> delegate = gson.getAdapter(TypeToken.get(param));
        return new ObjectPropertyTypeAdapter(delegate, this.strictProperties);
    }
}

