/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.authlibinjector;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilSession;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.javafx.ObservableOptionalCache;

public class AuthlibInjectorAccountFactory
extends AccountFactory<AuthlibInjectorAccount> {
    private AuthlibInjectorArtifactProvider downloader;
    private Function<String, AuthlibInjectorServer> serverLookup;

    public AuthlibInjectorAccountFactory(AuthlibInjectorArtifactProvider downloader, Function<String, AuthlibInjectorServer> serverLookup) {
        this.downloader = downloader;
        this.serverLookup = serverLookup;
    }

    @Override
    public AccountFactory.AccountLoginType getLoginType() {
        return AccountFactory.AccountLoginType.USERNAME_PASSWORD;
    }

    @Override
    public AuthlibInjectorAccount create(CharacterSelector selector, String username, String password, AccountFactory.ProgressCallback progressCallback, Object additionalData) throws AuthenticationException {
        Objects.requireNonNull(selector);
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        AuthlibInjectorServer server = (AuthlibInjectorServer)additionalData;
        return new AuthlibInjectorAccount(server, this.downloader, username, password, selector);
    }

    @Override
    public AuthlibInjectorAccount fromStorage(Map<Object, Object> storage) {
        Objects.requireNonNull(storage);
        YggdrasilSession session = YggdrasilSession.fromStorage(storage);
        String username = Lang.tryCast(storage.get("username"), String.class).orElseThrow(() -> new IllegalArgumentException("storage does not have username"));
        String apiRoot = Lang.tryCast(storage.get("serverBaseURL"), String.class).orElseThrow(() -> new IllegalArgumentException("storage does not have API root."));
        AuthlibInjectorServer server = this.serverLookup.apply(apiRoot);
        Lang.tryCast(storage.get("profileProperties"), Map.class).ifPresent(it -> {
            Map properties = it;
            GameProfile selected = session.getSelectedProfile();
            ObservableOptionalCache<UUID, CompleteGameProfile, AuthenticationException> profileRepository = server.getYggdrasilService().getProfileRepository();
            profileRepository.put(selected.getId(), new CompleteGameProfile(selected, properties));
            profileRepository.invalidate(selected.getId());
        });
        return new AuthlibInjectorAccount(server, this.downloader, username, session);
    }
}

