/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.authlibinjector;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorProvider;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.javafx.ObservableHelper;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Deserializer.class)
public class AuthlibInjectorServer
implements Observable {
    private static final Gson GSON = new GsonBuilder().create();
    private String url;
    @Nullable
    private String metadataResponse;
    private long metadataTimestamp;
    @Nullable
    private transient String name;
    private transient Map<String, String> links = Collections.emptyMap();
    private transient boolean nonEmailLogin;
    private transient boolean metadataRefreshed;
    private final transient ObservableHelper helper = new ObservableHelper(this);
    private final transient YggdrasilService yggdrasilService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthlibInjectorServer locateServer(String url) throws IOException {
        URL absoluteAli;
        url = AuthlibInjectorServer.addHttpsIfMissing(url);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        String ali = conn.getHeaderField("x-authlib-injector-api-location");
        if (ali != null && !AuthlibInjectorServer.urlEqualsIgnoreSlash(url, (absoluteAli = new URL(conn.getURL(), ali)).toString())) {
            conn.disconnect();
            url = absoluteAli.toString();
            conn = (HttpURLConnection)absoluteAli.openConnection();
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            AuthlibInjectorServer server = new AuthlibInjectorServer(url);
            server.refreshMetadata(IOUtils.readFullyWithoutClosing(conn.getInputStream()));
            AuthlibInjectorServer authlibInjectorServer = server;
            conn.disconnect();
            return authlibInjectorServer;
        }
        catch (Throwable throwable) {
            try {
                conn.disconnect();
                throw throwable;
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
        }
    }

    private static String addHttpsIfMissing(String url) {
        String lowercased = url.toLowerCase();
        if (!lowercased.startsWith("http://") && !lowercased.startsWith("https://")) {
            url = "https://" + url;
        }
        return url;
    }

    private static boolean urlEqualsIgnoreSlash(String a, String b) {
        if (!a.endsWith("/")) {
            a = a + "/";
        }
        if (!b.endsWith("/")) {
            b = b + "/";
        }
        return a.equals(b);
    }

    public AuthlibInjectorServer(String url) {
        this.url = url;
        this.yggdrasilService = new YggdrasilService(new AuthlibInjectorProvider(url));
    }

    public String getUrl() {
        return this.url;
    }

    public YggdrasilService getYggdrasilService() {
        return this.yggdrasilService;
    }

    public Optional<String> getMetadataResponse() {
        return Optional.ofNullable(this.metadataResponse);
    }

    public long getMetadataTimestamp() {
        return this.metadataTimestamp;
    }

    public String getName() {
        return Optional.ofNullable(this.name).orElse(this.url);
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public boolean isNonEmailLogin() {
        return this.nonEmailLogin;
    }

    public String fetchMetadataResponse() throws IOException {
        if (this.metadataResponse == null || !this.metadataRefreshed) {
            this.refreshMetadata();
        }
        return this.getMetadataResponse().get();
    }

    public void refreshMetadata() throws IOException {
        this.refreshMetadata(IOUtils.readFullyAsByteArray(new URL(this.url).openStream()));
    }

    private void refreshMetadata(byte[] rawResponse) throws IOException {
        long timestamp = System.currentTimeMillis();
        String text = new String(rawResponse, StandardCharsets.UTF_8);
        try {
            this.setMetadataResponse(text, timestamp);
        }
        catch (JsonParseException e) {
            throw new IOException("Malformed response\n" + text, e);
        }
        this.metadataRefreshed = true;
        Logging.LOG.info("authlib-injector server metadata refreshed: " + this.url);
        Platform.runLater(this.helper::invalidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMetadataResponse(String metadataResponse, long metadataTimestamp) throws JsonParseException {
        JsonObject response = GSON.fromJson(metadataResponse, JsonObject.class);
        if (response == null) {
            throw new JsonParseException("Metadata response is empty");
        }
        AuthlibInjectorServer authlibInjectorServer = this;
        synchronized (authlibInjectorServer) {
            this.metadataResponse = metadataResponse;
            this.metadataTimestamp = metadataTimestamp;
            Optional<JsonObject> metaObject = Lang.tryCast(response.get("meta"), JsonObject.class);
            this.name = metaObject.flatMap(meta -> Lang.tryCast(meta.get("serverName"), JsonPrimitive.class).map(JsonPrimitive::getAsString)).orElse(null);
            this.links = metaObject.flatMap(meta -> Lang.tryCast(meta.get("links"), JsonObject.class)).map(linksObject -> {
                LinkedHashMap converted = new LinkedHashMap();
                linksObject.entrySet().forEach(entry -> Lang.tryCast(entry.getValue(), JsonPrimitive.class).ifPresent(element -> converted.put(entry.getKey(), element.getAsString())));
                return converted;
            }).orElse(Collections.emptyMap());
            this.nonEmailLogin = metaObject.flatMap(meta -> Lang.tryCast(meta.get("feature.non_email_login"), JsonPrimitive.class)).map(it -> it.getAsBoolean()).orElse(false);
        }
    }

    public void invalidateMetadataCache() {
        this.metadataRefreshed = false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AuthlibInjectorServer)) {
            return false;
        }
        AuthlibInjectorServer another = (AuthlibInjectorServer)obj;
        return this.url.equals(another.url);
    }

    public String toString() {
        return this.name == null ? this.url : this.url + " (" + this.name + ")";
    }

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    public static class Deserializer
    implements JsonDeserializer<AuthlibInjectorServer> {
        @Override
        public AuthlibInjectorServer deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            AuthlibInjectorServer instance = new AuthlibInjectorServer(jsonObj.get("url").getAsString());
            if (jsonObj.has("name")) {
                instance.name = jsonObj.get("name").getAsString();
            }
            if (jsonObj.has("metadataResponse")) {
                try {
                    instance.setMetadataResponse(jsonObj.get("metadataResponse").getAsString(), jsonObj.get("metadataTimestamp").getAsLong());
                }
                catch (JsonParseException e) {
                    Logging.LOG.log(Level.WARNING, "Ignoring malformed metadata response cache: " + jsonObj.get("metadataResponse"), e);
                }
            }
            return instance;
        }
    }
}

