/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.yggdrasil;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilService;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilSession;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.javafx.ObservableOptionalCache;

public class YggdrasilAccountFactory
extends AccountFactory<YggdrasilAccount> {
    public static final YggdrasilAccountFactory MOJANG = new YggdrasilAccountFactory(YggdrasilService.MOJANG);
    private final YggdrasilService service;

    public YggdrasilAccountFactory(YggdrasilService service) {
        this.service = service;
    }

    @Override
    public AccountFactory.AccountLoginType getLoginType() {
        return AccountFactory.AccountLoginType.USERNAME_PASSWORD;
    }

    @Override
    public YggdrasilAccount create(CharacterSelector selector, String username, String password, AccountFactory.ProgressCallback progressCallback, Object additionalData) throws AuthenticationException {
        Objects.requireNonNull(selector);
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        return new YggdrasilAccount(this.service, username, password, selector);
    }

    @Override
    public YggdrasilAccount fromStorage(Map<Object, Object> storage) {
        Objects.requireNonNull(storage);
        YggdrasilSession session = YggdrasilSession.fromStorage(storage);
        String username = Lang.tryCast(storage.get("username"), String.class).orElseThrow(() -> new IllegalArgumentException("storage does not have username"));
        Lang.tryCast(storage.get("profileProperties"), Map.class).ifPresent(it -> {
            Map properties = it;
            GameProfile selected = session.getSelectedProfile();
            ObservableOptionalCache<UUID, CompleteGameProfile, AuthenticationException> profileRepository = this.service.getProfileRepository();
            profileRepository.put(selected.getId(), new CompleteGameProfile(selected, properties));
            profileRepository.invalidate(selected.getId());
        });
        return new YggdrasilAccount(this.service, username, session);
    }
}

