/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.fabric.FabricAPIVersionList;
import org.jackhuang.hmcl.download.fabric.FabricVersionList;
import org.jackhuang.hmcl.download.forge.ForgeBMCLVersionList;
import org.jackhuang.hmcl.download.game.GameVersionList;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderBMCLVersionList;
import org.jackhuang.hmcl.download.optifine.OptiFineBMCLVersionList;

public class BMCLAPIDownloadProvider
implements DownloadProvider {
    private final String apiRoot;
    private final GameVersionList game;
    private final FabricVersionList fabric;
    private final FabricAPIVersionList fabricApi;
    private final ForgeBMCLVersionList forge;
    private final LiteLoaderBMCLVersionList liteLoader;
    private final OptiFineBMCLVersionList optifine;

    public BMCLAPIDownloadProvider(String apiRoot) {
        this.apiRoot = apiRoot;
        this.game = new GameVersionList(this);
        this.fabric = new FabricVersionList(this);
        this.fabricApi = new FabricAPIVersionList(this);
        this.forge = new ForgeBMCLVersionList(apiRoot);
        this.liteLoader = new LiteLoaderBMCLVersionList(this);
        this.optifine = new OptiFineBMCLVersionList(apiRoot);
    }

    public String getApiRoot() {
        return this.apiRoot;
    }

    @Override
    public String getVersionListURL() {
        return this.apiRoot + "/mc/game/version_manifest.json";
    }

    @Override
    public String getAssetBaseURL() {
        return this.apiRoot + "/assets/";
    }

    @Override
    public VersionList<?> getVersionListById(String id) {
        switch (id) {
            case "game": {
                return this.game;
            }
            case "fabric": {
                return this.fabric;
            }
            case "fabric-api": {
                return this.fabricApi;
            }
            case "forge": {
                return this.forge;
            }
            case "liteloader": {
                return this.liteLoader;
            }
            case "optifine": {
                return this.optifine;
            }
        }
        throw new IllegalArgumentException("Unrecognized version list id: " + id);
    }

    @Override
    public String injectURL(String baseURL) {
        return baseURL.replace("https://bmclapi2.bangbang93.com", this.apiRoot).replace("https://launchermeta.mojang.com", this.apiRoot).replace("https://launcher.mojang.com", this.apiRoot).replace("https://libraries.minecraft.net", this.apiRoot + "/libraries").replaceFirst("https?://files\\.minecraftforge\\.net/maven", this.apiRoot + "/maven").replace("https://maven.minecraftforge.net", this.apiRoot + "/maven").replace("http://dl.liteloader.com/versions/versions.json", this.apiRoot + "/maven/com/mumfrey/liteloader/versions.json").replace("http://dl.liteloader.com/versions", this.apiRoot + "/maven").replace("https://meta.fabricmc.net", this.apiRoot + "/fabric-meta").replace("https://maven.fabricmc.net", this.apiRoot + "/maven").replace("https://authlib-injector.yushi.moe", this.apiRoot + "/mirrors/authlib-injector");
    }

    @Override
    public int getConcurrency() {
        return Math.max(Runtime.getRuntime().availableProcessors() * 2, 6);
    }
}

