/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;

public class MultipleSourceVersionList
extends VersionList<RemoteVersion> {
    private final List<VersionList<?>> backends;

    MultipleSourceVersionList(List<VersionList<?>> backends) {
        this.backends = backends;
        assert (backends.size() >= 1);
    }

    @Override
    public boolean hasType() {
        boolean hasType = this.backends.get(0).hasType();
        assert (this.backends.stream().allMatch(versionList -> versionList.hasType() == hasType));
        return hasType;
    }

    @Override
    public CompletableFuture<?> loadAsync() {
        throw new UnsupportedOperationException("MultipleSourceVersionList does not support loading the entire remote version list.");
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        throw new UnsupportedOperationException("MultipleSourceVersionList does not support loading the entire remote version list.");
    }

    @Override
    public CompletableFuture<?> refreshAsync(String gameVersion) {
        this.versions.clear(gameVersion);
        return CompletableFuture.anyOf((CompletableFuture[])this.backends.stream().map(versionList -> versionList.refreshAsync(gameVersion).thenRunAsync(() -> {
            this.lock.writeLock().lock();
            try {
                this.versions.putAll(gameVersion, versionList.getVersions(gameVersion));
            }
            finally {
                this.lock.writeLock().unlock();
            }
        })).toArray(CompletableFuture[]::new));
    }
}

