/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ForgeBMCLVersionList
extends VersionList<ForgeRemoteVersion> {
    private final String apiRoot;

    public ForgeBMCLVersionList(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public CompletableFuture<?> loadAsync() {
        throw new UnsupportedOperationException("ForgeBMCLVersionList does not support loading the entire Forge remote version list.");
    }

    @Override
    public CompletableFuture<?> refreshAsync() {
        throw new UnsupportedOperationException("ForgeBMCLVersionList does not support loading the entire Forge remote version list.");
    }

    @Override
    public CompletableFuture<?> refreshAsync(String gameVersion) {
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenApplyAsync(Lang.wrap(unused -> (List)HttpRequest.GET(this.apiRoot + "/forge/minecraft/" + gameVersion).getJson(new TypeToken<List<ForgeVersion>>(){}.getType())))).thenAcceptAsync(forgeVersions -> {
            this.lock.writeLock().lock();
            try {
                this.versions.clear(gameVersion);
                if (forgeVersions == null) {
                    return;
                }
                for (ForgeVersion version : forgeVersions) {
                    if (version == null) continue;
                    ArrayList<String> urls = new ArrayList<String>();
                    for (ForgeVersion.File file : version.getFiles()) {
                        if (!"installer".equals(file.getCategory()) || !"jar".equals(file.getFormat())) continue;
                        String classifier = gameVersion + "-" + version.getVersion() + (StringUtils.isNotBlank(version.getBranch()) ? "-" + version.getBranch() : "");
                        String fileName1 = "forge-" + classifier + "-" + file.getCategory() + "." + file.getFormat();
                        String fileName2 = "forge-" + classifier + "-" + gameVersion + "-" + file.getCategory() + "." + file.getFormat();
                        urls.add("https://files.minecraftforge.net/maven/net/minecraftforge/forge/" + classifier + "/" + fileName1);
                        urls.add("https://files.minecraftforge.net/maven/net/minecraftforge/forge/" + classifier + "-" + gameVersion + "/" + fileName2);
                        urls.add(NetworkUtils.withQuery("https://bmclapi2.bangbang93.com/forge/download", Lang.mapOf(Pair.pair("mcversion", version.getGameVersion()), Pair.pair("version", version.getVersion()), Pair.pair("branch", version.getBranch()), Pair.pair("category", file.getCategory()), Pair.pair("format", file.getFormat()))));
                    }
                    if (urls.isEmpty()) continue;
                    Instant releaseDate = null;
                    if (version.getModified() != null) {
                        try {
                            releaseDate = Instant.parse(version.getModified());
                        }
                        catch (DateTimeParseException e) {
                            Logging.LOG.log(Level.WARNING, "Failed to parse instant " + version.getModified(), e);
                        }
                    }
                    this.versions.put(gameVersion, new ForgeRemoteVersion(version.getGameVersion(), version.getVersion(), releaseDate, urls));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    @Override
    public Optional<ForgeRemoteVersion> getVersion(String gameVersion, String remoteVersion) {
        remoteVersion = StringUtils.substringAfter(remoteVersion, "-", remoteVersion);
        return super.getVersion(gameVersion, remoteVersion);
    }

    @Immutable
    public static final class ForgeVersion
    implements Validation {
        private final String branch;
        private final int build;
        private final String mcversion;
        private final String modified;
        private final String version;
        private final List<File> files;

        public ForgeVersion() {
            this(null, 0, "", null, "", Collections.emptyList());
        }

        public ForgeVersion(String branch, int build, String mcversion, String modified, String version, List<File> files) {
            this.branch = branch;
            this.build = build;
            this.mcversion = mcversion;
            this.modified = modified;
            this.version = version;
            this.files = files;
        }

        @Nullable
        public String getBranch() {
            return this.branch;
        }

        public int getBuild() {
            return this.build;
        }

        @NotNull
        public String getGameVersion() {
            return this.mcversion;
        }

        @Nullable
        public String getModified() {
            return this.modified;
        }

        @NotNull
        public String getVersion() {
            return this.version;
        }

        @NotNull
        public List<File> getFiles() {
            return this.files;
        }

        @Override
        public void validate() throws JsonParseException {
            if (this.files == null) {
                throw new JsonParseException("ForgeVersion files cannot be null");
            }
            if (this.version == null) {
                throw new JsonParseException("ForgeVersion version cannot be null");
            }
            if (this.mcversion == null) {
                throw new JsonParseException("ForgeVersion mcversion cannot be null");
            }
        }

        @Immutable
        public static final class File {
            private final String format;
            private final String category;
            private final String hash;

            public File() {
                this("", "", "");
            }

            public File(String format, String category, String hash) {
                this.format = format;
                this.category = category;
                this.hash = hash;
            }

            public String getFormat() {
                return this.format;
            }

            public String getCategory() {
                return this.category;
            }

            public String getHash() {
                return this.hash;
            }
        }
    }
}

