/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.game.AssetIndex;
import org.jackhuang.hmcl.game.AssetIndexInfo;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class GameAssetIndexDownloadTask
extends Task<Void> {
    private final AbstractDependencyManager dependencyManager;
    private final Version version;
    private final boolean forceDownloading;
    private final List<Task<?>> dependencies = new ArrayList(1);

    public GameAssetIndexDownloadTask(AbstractDependencyManager dependencyManager, Version version, boolean forceDownloading) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.forceDownloading = forceDownloading;
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() {
        boolean verifyHashCode;
        AssetIndexInfo assetIndexInfo = this.version.getAssetIndex();
        Path assetIndexFile = this.dependencyManager.getGameRepository().getIndexFile(this.version.getId(), assetIndexInfo.getId());
        boolean bl = verifyHashCode = StringUtils.isNotBlank(assetIndexInfo.getSha1()) && assetIndexInfo.getUrl().contains(assetIndexInfo.getSha1());
        if (Files.exists(assetIndexFile, new LinkOption[0]) && !this.forceDownloading) {
            if (verifyHashCode) {
                try {
                    String actualSum = Hex.encodeHex(DigestUtils.digest("SHA-1", assetIndexFile));
                    if (actualSum.equalsIgnoreCase(assetIndexInfo.getSha1())) {
                        return;
                    }
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to calculate sha1sum of file " + assetIndexInfo, e);
                }
            } else {
                try {
                    JsonUtils.fromNonNullJson(FileUtils.readText(assetIndexFile), AssetIndex.class);
                    return;
                }
                catch (JsonParseException | IOException e) {
                    // empty catch block
                }
            }
        }
        FileDownloadTask task = new FileDownloadTask(this.dependencyManager.getDownloadProvider().injectURLWithCandidates(assetIndexInfo.getUrl()), assetIndexFile.toFile(), verifyHashCode ? new FileDownloadTask.IntegrityCheck("SHA-1", assetIndexInfo.getSha1()) : null);
        task.setCacheRepository(this.dependencyManager.getCacheRepository());
        this.dependencies.add(task);
    }

    public static class GameAssetIndexMalformedException
    extends IOException {
    }
}

