/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.download.game.LibraryDownloadTask;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class GameLibrariesTask
extends Task<Void> {
    private final AbstractDependencyManager dependencyManager;
    private final Version version;
    private final boolean integrityCheck;
    private final List<Library> libraries;
    private final List<Task<?>> dependencies = new ArrayList();

    public GameLibrariesTask(AbstractDependencyManager dependencyManager, Version version, boolean integrityCheck) {
        this(dependencyManager, version, integrityCheck, version.resolve(dependencyManager.getGameRepository()).getLibraries());
    }

    public GameLibrariesTask(AbstractDependencyManager dependencyManager, Version version, boolean integrityCheck, List<Library> libraries) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.integrityCheck = integrityCheck;
        this.libraries = libraries;
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    public static boolean shouldDownloadLibrary(GameRepository gameRepository, Version version, Library library, boolean integrityCheck) {
        block7: {
            File file = gameRepository.getLibraryFile(version, library);
            Path jar = file.toPath();
            if (!file.isFile()) {
                return true;
            }
            try {
                String ext;
                if (integrityCheck && !library.getDownload().validateChecksum(jar, true)) {
                    return true;
                }
                if (integrityCheck && library.getChecksums() != null && !library.getChecksums().isEmpty() && !LibraryDownloadTask.checksumValid(file, library.getChecksums())) {
                    return true;
                }
                if (!integrityCheck || !(ext = FileUtils.getExtension(file)).equals("jar")) break block7;
                try {
                    FileDownloadTask.ZIP_INTEGRITY_CHECK_HANDLER.checkIntegrity(jar, jar);
                }
                catch (IOException ignored) {
                    return true;
                }
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Unable to calc hash value of file " + jar, e);
            }
        }
        return false;
    }

    @Override
    public void execute() {
        this.libraries.stream().filter(Library::appliesToCurrentEnvironment).forEach(library -> {
            File file = this.dependencyManager.getGameRepository().getLibraryFile(this.version, (Library)library);
            if (GameLibrariesTask.shouldDownloadLibrary(this.dependencyManager.getGameRepository(), this.version, library, this.integrityCheck)) {
                this.dependencies.add(new LibraryDownloadTask(this.dependencyManager, file, (Library)library));
            } else {
                this.dependencyManager.getCacheRepository().tryCacheLibrary((Library)library, file.toPath());
            }
        });
    }
}

