/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jackhuang.hmcl.game.ReleaseType;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.Validation;

public final class GameRemoteVersionInfo
implements Validation {
    @SerializedName(value="id")
    private final String gameVersion;
    @SerializedName(value="time")
    private final Date time;
    @SerializedName(value="releaseTime")
    private final Date releaseTime;
    @SerializedName(value="type")
    private final ReleaseType type;
    @SerializedName(value="url")
    private final String url;

    public GameRemoteVersionInfo() {
        this("", new Date(), new Date(), ReleaseType.UNKNOWN);
    }

    public GameRemoteVersionInfo(String gameVersion, Date time, Date releaseTime, ReleaseType type) {
        this(gameVersion, time, releaseTime, type, "https://libraries.minecraft.net/" + gameVersion + "/" + gameVersion + ".json");
    }

    public GameRemoteVersionInfo(String gameVersion, Date time, Date releaseTime, ReleaseType type, String url) {
        this.gameVersion = gameVersion;
        this.time = time;
        this.releaseTime = releaseTime;
        this.type = type;
        this.url = url;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public Date getTime() {
        return this.time;
    }

    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public ReleaseType getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void validate() throws JsonParseException {
        if (StringUtils.isBlank(this.gameVersion)) {
            throw new JsonParseException("GameRemoteVersion id cannot be blank");
        }
        if (StringUtils.isBlank(this.url)) {
            throw new JsonParseException("GameRemoteVersion url cannot be blank");
        }
    }
}

