/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseAddon;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.MurmurHash2;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class CurseForgeRemoteModRepository
implements RemoteModRepository {
    private static final String PREFIX = "https://addons-ecs.forgesvc.net";
    private final int section;
    public static final int SECTION_BUKKIT_PLUGIN = 5;
    public static final int SECTION_MOD = 6;
    public static final int SECTION_RESOURCE_PACK = 12;
    public static final int SECTION_WORLD = 17;
    public static final int SECTION_MODPACK = 4471;
    public static final int SECTION_CUSTOMIZATION = 4546;
    public static final int SECTION_ADDONS = 4559;
    public static final int SECTION_UNKNOWN1 = 4944;
    public static final int SECTION_UNKNOWN2 = 4979;
    public static final int SECTION_UNKNOWN3 = 4984;
    public static final CurseForgeRemoteModRepository MODS = new CurseForgeRemoteModRepository(6);
    public static final CurseForgeRemoteModRepository MODPACKS = new CurseForgeRemoteModRepository(4471);
    public static final CurseForgeRemoteModRepository RESOURCE_PACKS = new CurseForgeRemoteModRepository(12);
    public static final CurseForgeRemoteModRepository WORLDS = new CurseForgeRemoteModRepository(17);
    public static final CurseForgeRemoteModRepository CUSTOMIZATIONS = new CurseForgeRemoteModRepository(4546);

    public CurseForgeRemoteModRepository(int section) {
        this.section = section;
    }

    public List<CurseAddon> searchPaginated(String gameVersion, int category, int pageOffset, int pageSize, String searchFilter, int sort) throws IOException {
        String response = NetworkUtils.doGet(new URL(NetworkUtils.withQuery("https://addons-ecs.forgesvc.net/api/v2/addon/search", Lang.mapOf(Pair.pair("categoryId", Integer.toString(category)), Pair.pair("gameId", "432"), Pair.pair("gameVersion", gameVersion), Pair.pair("index", Integer.toString(pageOffset)), Pair.pair("pageSize", Integer.toString(pageSize)), Pair.pair("searchFilter", searchFilter), Pair.pair("sectionId", Integer.toString(this.section)), Pair.pair("sort", Integer.toString(sort))))));
        return (List)JsonUtils.fromNonNullJson(response, new TypeToken<List<CurseAddon>>(){}.getType());
    }

    @Override
    public Stream<RemoteMod> search(String gameVersion, RemoteModRepository.Category category, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sort) throws IOException {
        int categoryId = 0;
        if (category != null) {
            categoryId = ((Category)category.getSelf()).getId();
        }
        return this.searchPaginated(gameVersion, categoryId, pageOffset, pageSize, searchFilter, sort.ordinal()).stream().map(CurseAddon::toMod);
    }

    @Override
    public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile localModFile, Path file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = stream.read(buf, 0, buf.length)) != -1) {
                for (int i = 0; i < len; ++i) {
                    byte b = buf[i];
                    if (b == 9 || b == 10 || b == 13 || b == 32) continue;
                    baos.write(b);
                }
            }
        }
        long hash = Integer.toUnsignedLong(MurmurHash2.hash32(baos.toByteArray(), baos.size(), 1));
        FingerprintResponse response = HttpRequest.POST("https://addons-ecs.forgesvc.net/api/v2/fingerprint").json(Collections.singletonList(hash)).getJson(FingerprintResponse.class);
        if (response.getExactMatches() == null || response.getExactMatches().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(response.getExactMatches().get(0).getFile().toVersion());
    }

    @Override
    public RemoteMod getModById(String id) throws IOException {
        String response = NetworkUtils.doGet(NetworkUtils.toURL("https://addons-ecs.forgesvc.net/api/v2/addon/" + id));
        return JsonUtils.fromNonNullJson(response, CurseAddon.class).toMod();
    }

    @Override
    public Stream<RemoteMod.Version> getRemoteVersionsById(String id) throws IOException {
        String response = NetworkUtils.doGet(NetworkUtils.toURL("https://addons-ecs.forgesvc.net/api/v2/addon/" + id + "/files"));
        List files = (List)JsonUtils.fromNonNullJson(response, new TypeToken<List<CurseAddon.LatestFile>>(){}.getType());
        return files.stream().map(CurseAddon.LatestFile::toVersion);
    }

    public List<Category> getCategoriesImpl() throws IOException {
        String response = NetworkUtils.doGet(NetworkUtils.toURL("https://addons-ecs.forgesvc.net/api/v2/category/section/" + this.section));
        List categories = (List)JsonUtils.fromNonNullJson(response, new TypeToken<List<Category>>(){}.getType());
        return this.reorganizeCategories(categories, this.section);
    }

    @Override
    public Stream<RemoteModRepository.Category> getCategories() throws IOException {
        return this.getCategoriesImpl().stream().map(Category::toCategory);
    }

    private List<Category> reorganizeCategories(List<Category> categories, int rootId) {
        ArrayList<Category> result = new ArrayList<Category>();
        HashMap<Integer, Category> categoryMap = new HashMap<Integer, Category>();
        for (Category category : categories) {
            categoryMap.put(category.id, category);
        }
        for (Category category : categories) {
            if (category.parentGameCategoryId == rootId) {
                result.add(category);
                continue;
            }
            Category parentCategory = (Category)categoryMap.get(category.parentGameCategoryId);
            if (parentCategory == null) continue;
            parentCategory.subcategories.add(category);
        }
        return result;
    }

    public static class Category {
        private final int id;
        private final String name;
        private final String slug;
        private final String avatarUrl;
        private final int parentGameCategoryId;
        private final int rootGameCategoryId;
        private final int gameId;
        private final List<Category> subcategories;

        public Category() {
            this(0, "", "", "", 0, 0, 0, new ArrayList<Category>());
        }

        public Category(int id, String name, String slug, String avatarUrl, int parentGameCategoryId, int rootGameCategoryId, int gameId, List<Category> subcategories) {
            this.id = id;
            this.name = name;
            this.slug = slug;
            this.avatarUrl = avatarUrl;
            this.parentGameCategoryId = parentGameCategoryId;
            this.rootGameCategoryId = rootGameCategoryId;
            this.gameId = gameId;
            this.subcategories = subcategories;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSlug() {
            return this.slug;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public int getParentGameCategoryId() {
            return this.parentGameCategoryId;
        }

        public int getRootGameCategoryId() {
            return this.rootGameCategoryId;
        }

        public int getGameId() {
            return this.gameId;
        }

        public List<Category> getSubcategories() {
            return this.subcategories;
        }

        public RemoteModRepository.Category toCategory() {
            return new RemoteModRepository.Category(this, Integer.toString(this.id), this.getSubcategories().stream().map(Category::toCategory).collect(Collectors.toList()));
        }
    }

    private static class FingerprintResponse {
        private final boolean isCacheBuilt;
        private final List<CurseAddon> exactMatches;
        private final List<Long> exactFingerprints;

        public FingerprintResponse(boolean isCacheBuilt, List<CurseAddon> exactMatches, List<Long> exactFingerprints) {
            this.isCacheBuilt = isCacheBuilt;
            this.exactMatches = exactMatches;
            this.exactFingerprints = exactFingerprints;
        }

        public boolean isCacheBuilt() {
            return this.isCacheBuilt;
        }

        public List<CurseAddon> getExactMatches() {
            return this.exactMatches;
        }

        public List<Long> getExactFingerprints() {
            return this.exactFingerprints;
        }
    }
}

