/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.FileUtils;

public class AuthlibInjectorServers
implements Validation {
    public static final String CONFIG_FILENAME = "authlib-injectors.json";
    private final List<String> urls;
    private static final Path configLocation = Paths.get("authlib-injectors.json", new String[0]);
    private static AuthlibInjectorServers configInstance;

    public AuthlibInjectorServers(List<String> urls) {
        this.urls = urls;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    @Override
    public void validate() throws JsonParseException {
        if (this.urls == null) {
            throw new JsonParseException("authlib-injectors.json -> urls cannot be null");
        }
    }

    public static synchronized void init() {
        if (configInstance != null) {
            throw new IllegalStateException("AuthlibInjectorServers is already loaded");
        }
        configInstance = new AuthlibInjectorServers(Collections.emptyList());
        if (Files.exists(configLocation, new LinkOption[0])) {
            try {
                String content = FileUtils.readText(configLocation);
                configInstance = JsonUtils.GSON.fromJson(content, AuthlibInjectorServers.class);
            }
            catch (JsonParseException | IOException e) {
                Logging.LOG.log(Level.WARNING, "Malformed authlib-injectors.json", e);
            }
        }
        if (ConfigHolder.isNewlyCreated() && !AuthlibInjectorServers.getConfigInstance().getUrls().isEmpty()) {
            ConfigHolder.config().setPreferredLoginType(Accounts.getLoginType(Accounts.FACTORY_AUTHLIB_INJECTOR));
            for (String url : AuthlibInjectorServers.getConfigInstance().getUrls()) {
                Task.supplyAsync(Schedulers.io(), () -> AuthlibInjectorServer.locateServer(url)).thenAcceptAsync(Schedulers.javafx(), server -> ConfigHolder.config().getAuthlibInjectorServers().add(server)).start();
            }
        }
    }

    public static AuthlibInjectorServers getConfigInstance() {
        return configInstance;
    }
}

