/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.util.i18n.I18n;

public class CrashWindow
extends Stage {
    public CrashWindow(String text) {
        Label lblCrash = new Label();
        if (UpdateChecker.isOutdated()) {
            lblCrash.setText(I18n.i18n("launcher.crash_out_dated"));
        } else {
            lblCrash.setText(I18n.i18n("launcher.crash"));
        }
        lblCrash.setWrapText(true);
        TextArea textArea = new TextArea();
        textArea.setText(text);
        textArea.setEditable(false);
        Button btnContact = new Button();
        btnContact.setText(I18n.i18n("launcher.contact"));
        btnContact.setOnMouseClicked(event -> FXUtils.openLink("https://hmcl.huangyuhui.net/contact"));
        HBox box = new HBox();
        box.setStyle("-fx-padding: 8px;");
        box.getChildren().add((Object)btnContact);
        box.setAlignment(Pos.CENTER_RIGHT);
        BorderPane pane = new BorderPane();
        StackPane stackPane = new StackPane();
        stackPane.setStyle("-fx-padding: 8px;");
        stackPane.getChildren().add((Object)lblCrash);
        pane.setTop((Node)stackPane);
        pane.setCenter((Node)textArea);
        pane.setBottom((Node)box);
        Scene scene = new Scene((Parent)pane, 800.0, 480.0);
        this.setScene(scene);
        this.getIcons().add((Object)FXUtils.newImage("/assets/img/icon.png"));
        this.setTitle(I18n.i18n("message.error"));
        this.setOnCloseRequest(e -> System.exit(1));
    }
}

