/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.swing.JOptionPane;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class LogWindow
extends Stage {
    private final ArrayDeque<Log> logs = new ArrayDeque();
    private final Map<Log4jLevel, SimpleIntegerProperty> levelCountMap = new EnumMap<Log4jLevel, SimpleIntegerProperty>(Log4jLevel.class){
        {
            for (Log4jLevel level : Log4jLevel.values()) {
                this.put(level, new SimpleIntegerProperty());
            }
        }
    };
    private final Map<Log4jLevel, SimpleBooleanProperty> levelShownMap = new EnumMap<Log4jLevel, SimpleBooleanProperty>(Log4jLevel.class){
        {
            for (Log4jLevel level : Log4jLevel.values()) {
                SimpleBooleanProperty property = new SimpleBooleanProperty(true);
                this.put(level, property);
            }
        }
    };
    private final LogWindowImpl impl = new LogWindowImpl();
    private final ChangeListener<Number> logLinesListener = FXUtils.onWeakChange(ConfigHolder.config().logLinesProperty(), logLines -> this.checkLogCount());
    private Consumer<String> exportGameCrashInfoCallback;
    private boolean stopCheckLogCount = false;

    public LogWindow() {
        this.setScene(new Scene((Parent)this.impl, 800.0, 480.0));
        this.getScene().getStylesheets().addAll((Object[])ConfigHolder.config().getTheme().getStylesheets(ConfigHolder.config().getLauncherFontFamily()));
        this.setTitle(I18n.i18n("logwindow.title"));
        this.getIcons().add((Object)FXUtils.newImage("/assets/img/icon.png"));
        this.levelShownMap.values().forEach(property -> property.addListener((a, b, newValue) -> this.shakeLogs()));
    }

    public void logLine(String line, Log4jLevel level) {
        Log log = new Log(StringUtils.parseEscapeSequence(line), level);
        this.logs.add(log);
        if (this.levelShownMap.get((Object)level).get()) {
            this.impl.listView.getItems().add((Object)log);
        }
        this.levelCountMap.get((Object)level).setValue((Number)(this.levelCountMap.get((Object)level).getValue() + 1));
        if (!this.stopCheckLogCount) {
            this.checkLogCount();
        }
    }

    public void showGameCrashReport(Consumer<String> exportGameCrashInfoCallback) {
        this.exportGameCrashInfoCallback = exportGameCrashInfoCallback;
        this.impl.showCrashReport.set(true);
        this.stopCheckLogCount = true;
        for (Log log : this.impl.listView.getItems()) {
            if (!log.log.contains("Minecraft Crash Report")) continue;
            Platform.runLater(() -> this.impl.listView.scrollTo((Object)log));
            break;
        }
        this.show();
    }

    public void showNormal() {
        this.impl.showCrashReport.set(false);
        this.show();
    }

    private void shakeLogs() {
        this.impl.listView.getItems().setAll((Collection)this.logs.stream().filter(log -> this.levelShownMap.get((Object)((Log)log).level).get()).collect(Collectors.toList()));
    }

    private void checkLogCount() {
        while (this.logs.size() > ConfigHolder.config().getLogLines()) {
            Log removedLog = this.logs.removeFirst();
            if (this.impl.listView.getItems().isEmpty() || this.impl.listView.getItems().get(0) != removedLog) continue;
            this.impl.listView.getItems().remove(0);
        }
    }

    private static class Log {
        private final String log;
        private final Log4jLevel level;

        public Log(String log, Log4jLevel level) {
            this.log = log;
            this.level = level;
        }
    }

    public class LogWindowImpl
    extends Control {
        private ListView<Log> listView = new JFXListView<Log>();
        private BooleanProperty autoScroll = new SimpleBooleanProperty();
        private List<StringProperty> buttonText = IntStream.range(0, 5).mapToObj(x -> new SimpleStringProperty()).collect(Collectors.toList());
        private List<BooleanProperty> showLevel = IntStream.range(0, 5).mapToObj(x -> new SimpleBooleanProperty(true)).collect(Collectors.toList());
        private JFXComboBox<String> cboLines = new JFXComboBox();
        private BooleanProperty showCrashReport = new SimpleBooleanProperty();

        LogWindowImpl() {
            this.getStyleClass().add((Object)"log-window");
            boolean flag = false;
            this.cboLines.getItems().setAll((Object[])new String[]{"500", "2000", "5000"});
            for (String i : this.cboLines.getItems()) {
                if (!Integer.toString(ConfigHolder.config().getLogLines()).equals(i)) continue;
                this.cboLines.getSelectionModel().select((Object)i);
                flag = true;
            }
            this.cboLines.getSelectionModel().selectedItemProperty().addListener((a, b, newValue) -> ConfigHolder.config().setLogLines(newValue == null ? 100 : Integer.parseInt(newValue)));
            if (!flag) {
                this.cboLines.getSelectionModel().select(0);
            }
            Log4jLevel[] levels = new Log4jLevel[]{Log4jLevel.FATAL, Log4jLevel.ERROR, Log4jLevel.WARN, Log4jLevel.INFO, Log4jLevel.DEBUG};
            String[] suffix = new String[]{"fatals", "errors", "warns", "infos", "debugs"};
            for (int i = 0; i < 5; ++i) {
                this.buttonText.get(i).bind((ObservableValue)Bindings.concat((Object[])new Object[]{LogWindow.this.levelCountMap.get((Object)levels[i]), " " + suffix[i]}));
                ((SimpleBooleanProperty)LogWindow.this.levelShownMap.get((Object)levels[i])).bind((ObservableValue)this.showLevel.get(i));
            }
        }

        private void onTerminateGame() {
            LauncherHelper.stopManagedProcesses();
        }

        private void onClear() {
            ((LogWindow)LogWindow.this).impl.listView.getItems().clear();
            LogWindow.this.logs.clear();
        }

        private void onExportLogs() {
            Lang.thread(() -> {
                Path logFile = Paths.get("minecraft-exported-logs-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".log", new String[0]).toAbsolutePath();
                try {
                    Files.write(logFile, (Iterable<? extends CharSequence>)LogWindow.this.logs.stream().map(x -> ((Log)x).log).collect(Collectors.toList()), new OpenOption[0]);
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to export logs", e);
                    return;
                }
                JOptionPane.showMessageDialog(null, I18n.i18n("settings.launcher.launcher_log.export.success", logFile), I18n.i18n("settings.launcher.launcher_log.export"), 1);
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(logFile.toFile());
                    }
                    catch (IOException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
            });
        }

        private void onExportGameCrashInfo() {
            if (LogWindow.this.exportGameCrashInfoCallback == null) {
                return;
            }
            LogWindow.this.exportGameCrashInfoCallback.accept(LogWindow.this.logs.stream().map(x -> ((Log)x).log).collect(Collectors.joining(OperatingSystem.LINE_SEPARATOR)));
        }

        protected Skin<?> createDefaultSkin() {
            return new LogWindowSkin(this);
        }
    }

    private static class LogWindowSkin
    extends SkinBase<LogWindowImpl> {
        private static PseudoClass EMPTY = PseudoClass.getPseudoClass((String)"empty");
        private static PseudoClass FATAL = PseudoClass.getPseudoClass((String)"fatal");
        private static PseudoClass ERROR = PseudoClass.getPseudoClass((String)"error");
        private static PseudoClass WARN = PseudoClass.getPseudoClass((String)"warn");
        private static PseudoClass INFO = PseudoClass.getPseudoClass((String)"info");
        private static PseudoClass DEBUG = PseudoClass.getPseudoClass((String)"debug");
        private static PseudoClass TRACE = PseudoClass.getPseudoClass((String)"trace");

        private static ToggleButton createToggleButton(String backgroundColor, StringProperty buttonText, BooleanProperty showLevel) {
            ToggleButton button = new ToggleButton();
            button.setStyle("-fx-background-color: " + backgroundColor + ";");
            button.getStyleClass().add((Object)"log-toggle");
            button.textProperty().bind((ObservableValue)buttonText);
            button.setSelected(true);
            showLevel.bind((ObservableValue)button.selectedProperty());
            return button;
        }

        protected LogWindowSkin(LogWindowImpl control) {
            super((Control)control);
            VBox vbox = new VBox(3.0);
            vbox.setPadding(new Insets(3.0, 0.0, 3.0, 0.0));
            vbox.setStyle("-fx-background-color: white");
            this.getChildren().setAll((Object[])new Node[]{vbox});
            BorderPane borderPane = new BorderPane();
            borderPane.setPadding(new Insets(0.0, 3.0, 0.0, 3.0));
            HBox hBox = new HBox(3.0);
            hBox.setPadding(new Insets(0.0, 0.0, 0.0, 4.0));
            hBox.setAlignment(Pos.CENTER_LEFT);
            Label label = new Label(I18n.i18n("logwindow.show_lines"));
            hBox.getChildren().setAll((Object[])new Node[]{label, control.cboLines});
            borderPane.setLeft((Node)hBox);
            hBox = new HBox(3.0);
            hBox.getChildren().setAll((Object[])new Node[]{LogWindowSkin.createToggleButton("#F7A699", (StringProperty)control.buttonText.get(0), (BooleanProperty)control.showLevel.get(0)), LogWindowSkin.createToggleButton("#FFCCBB", (StringProperty)control.buttonText.get(1), (BooleanProperty)control.showLevel.get(1)), LogWindowSkin.createToggleButton("#FFEECC", (StringProperty)control.buttonText.get(2), (BooleanProperty)control.showLevel.get(2)), LogWindowSkin.createToggleButton("#FBFBFB", (StringProperty)control.buttonText.get(3), (BooleanProperty)control.showLevel.get(3)), LogWindowSkin.createToggleButton("#EEE9E0", (StringProperty)control.buttonText.get(4), (BooleanProperty)control.showLevel.get(4))});
            borderPane.setRight((Node)hBox);
            vbox.getChildren().add((Object)borderPane);
            final ListView listView = control.listView;
            listView.getItems().addListener(observable -> {
                if (!listView.getItems().isEmpty() && control.autoScroll.get()) {
                    listView.scrollTo(listView.getItems().size() - 1);
                }
            });
            listView.setStyle("-fx-font-family: " + ConfigHolder.config().getFontFamily() + "; -fx-font-size: " + ConfigHolder.config().getFontSize() + "px;");
            listView.setCellFactory(x -> new ListCell<Log>(){
                {
                    this.getStyleClass().add((Object)"log-window-list-cell");
                    Region clippedContainer = (Region)listView.lookup(".clipped-container");
                    if (clippedContainer != null) {
                        this.maxWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                        this.prefWidthProperty().bind((ObservableValue)clippedContainer.widthProperty());
                    }
                    this.setPadding(new Insets(2.0));
                    this.setWrapText(true);
                    this.setGraphic(null);
                }

                protected void updateItem(Log item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.pseudoClassStateChanged(EMPTY, empty);
                    this.pseudoClassStateChanged(FATAL, !empty && item.level == Log4jLevel.FATAL);
                    this.pseudoClassStateChanged(ERROR, !empty && item.level == Log4jLevel.ERROR);
                    this.pseudoClassStateChanged(WARN, !empty && item.level == Log4jLevel.WARN);
                    this.pseudoClassStateChanged(INFO, !empty && item.level == Log4jLevel.INFO);
                    this.pseudoClassStateChanged(DEBUG, !empty && item.level == Log4jLevel.DEBUG);
                    this.pseudoClassStateChanged(TRACE, !empty && item.level == Log4jLevel.TRACE);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(item.log);
                    }
                }
            });
            VBox.setVgrow((Node)listView, (Priority)Priority.ALWAYS);
            vbox.getChildren().add((Object)listView);
            BorderPane bottom = new BorderPane();
            JFXButton exportGameCrashInfoButton = new JFXButton(I18n.i18n("logwindow.export_game_crash_logs"));
            exportGameCrashInfoButton.setOnMouseClicked(e -> ((LogWindowImpl)this.getSkinnable()).onExportGameCrashInfo());
            exportGameCrashInfoButton.visibleProperty().bind((ObservableValue)((LogWindowImpl)this.getSkinnable()).showCrashReport);
            bottom.setLeft((Node)exportGameCrashInfoButton);
            HBox hBox2 = new HBox(3.0);
            bottom.setRight((Node)hBox2);
            hBox2.setAlignment(Pos.CENTER_RIGHT);
            hBox2.setPadding(new Insets(0.0, 3.0, 0.0, 3.0));
            JFXCheckBox autoScrollCheckBox = new JFXCheckBox(I18n.i18n("logwindow.autoscroll"));
            autoScrollCheckBox.setSelected(true);
            control.autoScroll.bind((ObservableValue)autoScrollCheckBox.selectedProperty());
            JFXButton terminateButton = new JFXButton(I18n.i18n("logwindow.terminate_game"));
            terminateButton.setOnMouseClicked(e -> ((LogWindowImpl)this.getSkinnable()).onTerminateGame());
            JFXButton exportLogsButton = new JFXButton(I18n.i18n("button.export"));
            exportLogsButton.setOnMouseClicked(e -> ((LogWindowImpl)this.getSkinnable()).onExportLogs());
            JFXButton clearButton = new JFXButton(I18n.i18n("button.clear"));
            clearButton.setOnMouseClicked(e -> ((LogWindowImpl)this.getSkinnable()).onClear());
            hBox2.getChildren().setAll((Object[])new Node[]{autoScrollCheckBox, exportLogsButton, terminateButton, clearButton});
            vbox.getChildren().add((Object)bottom);
        }
    }
}

