/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXTextField;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import moe.mickey.minecraft.skin.fx.SkinCanvas;
import moe.mickey.minecraft.skin.fx.animation.SkinAniRunning;
import moe.mickey.minecraft.skin.fx.animation.SkinAniWavingArms;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.offline.Skin;
import org.jackhuang.hmcl.auth.yggdrasil.TextureModel;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.FileSelector;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.ui.construct.URLValidator;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public class OfflineAccountSkinPane
extends StackPane {
    private final OfflineAccount account;
    private final MultiFileItem<Skin.Type> skinItem = new MultiFileItem();
    private final JFXTextField cslApiField = new JFXTextField();
    private final JFXComboBox<TextureModel> modelCombobox = new JFXComboBox();
    private final FileSelector skinSelector = new FileSelector();
    private final FileSelector capeSelector = new FileSelector();
    private final InvalidationListener skinBinding;

    public OfflineAccountSkinPane(OfflineAccount account) {
        this.account = account;
        this.getStyleClass().add((Object)"skin-pane");
        JFXDialogLayout layout = new JFXDialogLayout();
        this.getChildren().setAll((Object[])new Node[]{layout});
        layout.setHeading(new Node[]{new Label(I18n.i18n("account.skin"))});
        BorderPane pane = new BorderPane();
        SkinCanvas canvas = new SkinCanvas(SkinCanvas.STEVE, 300.0, 300.0, true);
        StackPane canvasPane = new StackPane(new Node[]{canvas});
        canvasPane.setPrefWidth(300.0);
        canvasPane.setPrefHeight(300.0);
        pane.setCenter((Node)canvas);
        canvas.getAnimationplayer().addSkinAnimation(new SkinAniWavingArms(100, 2000, 7.5, canvas), new SkinAniRunning(100, 100, 30.0, canvas));
        canvas.enableRotation(0.5);
        canvas.addEventHandler(DragEvent.DRAG_OVER, e -> {
            File file;
            if (e.getDragboard().hasFiles() && (file = (File)e.getDragboard().getFiles().get(0)).getAbsolutePath().endsWith(".png")) {
                e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        canvas.addEventHandler(DragEvent.DRAG_DROPPED, e -> {
            if (e.isAccepted()) {
                File skin = (File)e.getDragboard().getFiles().get(0);
                Platform.runLater(() -> {
                    this.skinSelector.setValue(skin.getAbsolutePath());
                    this.skinItem.setSelectedData(Skin.Type.LOCAL_FILE);
                });
            }
        });
        StackPane skinOptionPane = new StackPane();
        skinOptionPane.setMaxWidth(300.0);
        VBox optionPane = new VBox(new Node[]{this.skinItem, skinOptionPane});
        pane.setRight((Node)optionPane);
        layout.setBody(new Node[]{pane});
        this.cslApiField.setPromptText(I18n.i18n("account.skin.type.csl_api.location.hint"));
        this.cslApiField.setValidators(new URLValidator());
        this.skinItem.loadChildren(Arrays.asList(new MultiFileItem.Option<Skin.Type>(I18n.i18n("message.default"), Skin.Type.DEFAULT), new MultiFileItem.Option<Skin.Type>("Steve", Skin.Type.STEVE), new MultiFileItem.Option<Skin.Type>("Alex", Skin.Type.ALEX), new MultiFileItem.Option<Skin.Type>(I18n.i18n("account.skin.type.local_file"), Skin.Type.LOCAL_FILE), new MultiFileItem.Option<Skin.Type>("LittleSkin", Skin.Type.LITTLE_SKIN), new MultiFileItem.Option<Skin.Type>(I18n.i18n("account.skin.type.csl_api"), Skin.Type.CUSTOM_SKIN_LOADER_API)));
        this.modelCombobox.setConverter(FXUtils.stringConverter(model -> I18n.i18n("account.skin.model." + model.modelName)));
        this.modelCombobox.getItems().setAll((Object[])new TextureModel[]{TextureModel.STEVE, TextureModel.ALEX});
        if (account.getSkin() == null) {
            this.skinItem.setSelectedData(Skin.Type.DEFAULT);
            this.modelCombobox.setValue((Object)TextureModel.STEVE);
        } else {
            this.skinItem.setSelectedData(account.getSkin().getType());
            this.cslApiField.setText(account.getSkin().getCslApi());
            this.modelCombobox.setValue((Object)account.getSkin().getTextureModel());
            this.skinSelector.setValue(account.getSkin().getLocalSkinPath());
            this.capeSelector.setValue(account.getSkin().getLocalCapePath());
        }
        this.skinBinding = FXUtils.observeWeak(() -> this.getSkin().load(account.getUsername()).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception != null) {
                Logging.LOG.log(Level.WARNING, "Failed to load skin", exception);
                Controllers.showToast(I18n.i18n("message.failed"));
            } else {
                if (result == null || result.getSkin() == null) {
                    canvas.updateSkin(this.getDefaultTexture(), this.isDefaultSlim());
                    return;
                }
                canvas.updateSkin(new Image(result.getSkin().getInputStream()), result.getModel() == TextureModel.ALEX);
            }
        }).start(), new Observable[]{this.skinItem.selectedDataProperty(), this.cslApiField.textProperty(), this.skinSelector.valueProperty(), this.capeSelector.valueProperty()});
        FXUtils.onChangeAndOperate(this.skinItem.selectedDataProperty(), selectedData -> {
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
            gridPane.setHgap(16.0);
            gridPane.setVgap(8.0);
            gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing()});
            switch (selectedData) {
                case DEFAULT: 
                case STEVE: 
                case ALEX: {
                    break;
                }
                case LITTLE_SKIN: {
                    HintPane hint = new HintPane(MessageDialogPane.MessageType.INFO);
                    hint.setText(I18n.i18n("account.skin.type.little_skin.hint"));
                    gridPane.addRow(0, new Node[]{hint});
                    break;
                }
                case LOCAL_FILE: {
                    gridPane.addRow(0, new Node[]{new Label(I18n.i18n("account.skin.model")), this.modelCombobox});
                    gridPane.addRow(1, new Node[]{new Label(I18n.i18n("account.skin")), this.skinSelector});
                    gridPane.addRow(2, new Node[]{new Label(I18n.i18n("account.cape")), this.capeSelector});
                    break;
                }
                case CUSTOM_SKIN_LOADER_API: {
                    gridPane.addRow(0, new Node[]{new Label(I18n.i18n("account.skin.type.csl_api.location")), this.cslApiField});
                }
            }
            skinOptionPane.getChildren().setAll((Object[])new Node[]{gridPane});
        });
        JFXButton acceptButton = new JFXButton(I18n.i18n("button.ok"));
        acceptButton.getStyleClass().add((Object)"dialog-accept");
        acceptButton.setOnAction(e -> {
            account.setSkin(this.getSkin());
            this.fireEvent(new DialogCloseEvent());
        });
        JFXHyperlink littleSkinLink = new JFXHyperlink(I18n.i18n("account.skin.type.little_skin"));
        littleSkinLink.setOnAction(e -> FXUtils.openLink("https://mcskin.littleservice.cn/"));
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"dialog-cancel");
        cancelButton.setOnAction(e -> this.fireEvent(new DialogCloseEvent()));
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
        layout.setActions(new Node[]{littleSkinLink, acceptButton, cancelButton});
    }

    private Skin getSkin() {
        return new Skin(this.skinItem.getSelectedData(), this.cslApiField.getText(), (TextureModel)((Object)this.modelCombobox.getValue()), this.skinSelector.getValue(), this.capeSelector.getValue());
    }

    private boolean isDefaultSlim() {
        return TextureModel.detectUUID(this.account.getUUID()) == TextureModel.ALEX;
    }

    private Image getDefaultTexture() {
        if (this.isDefaultSlim()) {
            return SkinCanvas.ALEX;
        }
        return SkinCanvas.STEVE;
    }
}

