/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.List;
import java.util.function.Consumer;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.construct.ComponentListCell;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

@DefaultProperty(value="content")
public class ComponentList
extends Control {
    private final StringProperty title = new SimpleStringProperty((Object)this, "title", "Group");
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle", "");
    private final IntegerProperty depth = new SimpleIntegerProperty((Object)this, "depth", 0);
    private boolean hasSubtitle = false;
    public final ObservableList<Node> content = FXCollections.observableArrayList();
    private boolean expanded = false;
    private Consumer<ComponentList> lazyInitializer;

    public ComponentList() {
        this.getStyleClass().add((Object)"options-list");
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public int getDepth() {
        return this.depth.get();
    }

    public IntegerProperty depthProperty() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth.set(depth);
    }

    public boolean isHasSubtitle() {
        return this.hasSubtitle;
    }

    public void setHasSubtitle(boolean hasSubtitle) {
        this.hasSubtitle = hasSubtitle;
    }

    public ObservableList<Node> getContent() {
        return this.content;
    }

    public void setLazyInitializer(Consumer<ComponentList> lazyInitializer) {
        this.lazyInitializer = lazyInitializer;
    }

    public void onExpand() {
        if (!this.expanded && this.lazyInitializer != null) {
            this.lazyInitializer.accept(this);
            this.setNeedsLayout(true);
        }
        this.expanded = true;
    }

    protected javafx.scene.control.Skin<?> createDefaultSkin() {
        return new Skin(this);
    }

    public static Node createComponentListTitle(String title) {
        HBox node = new HBox();
        node.setAlignment(Pos.CENTER_LEFT);
        node.setPadding(new Insets(8.0, 0.0, 0.0, 0.0));
        Label advanced = new Label(title);
        node.getChildren().setAll((Object[])new Node[]{advanced});
        return node;
    }

    public static void setVgrow(Node node, Priority priority) {
        node.getProperties().put((Object)"ComponentList.vgrow", (Object)priority);
    }

    protected static class Skin
    extends SkinBase<ComponentList> {
        private static final PseudoClass PSEUDO_CLASS_FIRST = PseudoClass.getPseudoClass((String)"first");
        private static final PseudoClass PSEUDO_CLASS_LAST = PseudoClass.getPseudoClass((String)"last");
        private final ObservableList<Node> list;
        private final ObjectBinding<Node> firstItem;
        private final ObjectBinding<Node> lastItem;

        protected Skin(ComponentList control) {
            super((Control)control);
            this.list = MappedObservableList.create(control.getContent(), node -> {
                ComponentListCell cell = new ComponentListCell((Node)node);
                cell.getStyleClass().add((Object)"options-list-item");
                if (node.getProperties().containsKey((Object)"ComponentList.vgrow")) {
                    VBox.setVgrow((Node)cell, (Priority)((Priority)node.getProperties().get((Object)"ComponentList.vgrow")));
                }
                if (node.getProperties().containsKey((Object)"ComponentList.noPadding")) {
                    cell.getStyleClass().add((Object)"no-padding");
                }
                return cell;
            });
            this.firstItem = Bindings.valueAt(this.list, (int)0);
            this.firstItem.addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    newValue.pseudoClassStateChanged(PSEUDO_CLASS_FIRST, true);
                }
                if (oldValue != null) {
                    oldValue.pseudoClassStateChanged(PSEUDO_CLASS_FIRST, false);
                }
            });
            if (!this.list.isEmpty()) {
                ((Node)this.list.get(0)).pseudoClassStateChanged(PSEUDO_CLASS_FIRST, true);
            }
            this.lastItem = Bindings.valueAt(this.list, (ObservableNumberValue)Bindings.subtract((ObservableNumberValue)Bindings.size(this.list), (int)1));
            this.lastItem.addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    newValue.pseudoClassStateChanged(PSEUDO_CLASS_LAST, true);
                }
                if (oldValue != null) {
                    oldValue.pseudoClassStateChanged(PSEUDO_CLASS_LAST, false);
                }
            });
            if (!this.list.isEmpty()) {
                ((Node)this.list.get(this.list.size() - 1)).pseudoClassStateChanged(PSEUDO_CLASS_LAST, true);
            }
            VBox vbox = new VBox();
            vbox.setFillWidth(true);
            Bindings.bindContent((List)vbox.getChildren(), this.list);
            this.getChildren().setAll((Object[])new Node[]{vbox});
        }
    }
}

