/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXToggleButton;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.util.StringUtils;

public class OptionToggleButton
extends StackPane {
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty subtitle = new SimpleStringProperty();
    private final BooleanProperty selected = new SimpleBooleanProperty();

    public OptionToggleButton() {
        this.getProperties().put((Object)"ComponentList.noPadding", (Object)true);
        BorderPane pane = new BorderPane();
        pane.setPadding(new Insets(8.0, 8.0, 8.0, 16.0));
        RipplerContainer container = new RipplerContainer((Node)pane);
        this.getChildren().setAll((Object[])new Node[]{container});
        VBox left = new VBox();
        left.setMouseTransparent(true);
        Label titleLabel = new Label();
        titleLabel.textProperty().bind((ObservableValue)this.title);
        Label subtitleLabel = new Label();
        subtitleLabel.setMouseTransparent(true);
        subtitleLabel.textProperty().bind((ObservableValue)this.subtitle);
        pane.setLeft((Node)left);
        left.setAlignment(Pos.CENTER_LEFT);
        JFXToggleButton toggleButton = new JFXToggleButton();
        pane.setRight((Node)toggleButton);
        toggleButton.selectedProperty().bindBidirectional((Property)this.selected);
        toggleButton.setSize(8.0);
        FXUtils.setLimitHeight((Region)toggleButton, 30.0);
        container.setOnMouseClicked(e -> toggleButton.setSelected(!toggleButton.isSelected()));
        FXUtils.onChangeAndOperate(this.subtitleProperty(), subtitle -> {
            if (StringUtils.isNotBlank(subtitle)) {
                left.getChildren().setAll((Object[])new Node[]{titleLabel, subtitleLabel});
            } else {
                left.getChildren().setAll((Object[])new Node[]{titleLabel});
            }
        });
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

