/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXSpinner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.fabric.FabricAPIRemoteVersion;
import org.jackhuang.hmcl.download.fabric.FabricRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.IconedTwoLineListItem;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.HMCLService;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.Locales;

public final class VersionsPage
extends BorderPane
implements WizardPage,
Refreshable {
    private final String gameVersion;
    private final String libraryId;
    private final String title;
    private final Navigation navigation;
    @FXML
    private JFXListView<RemoteVersion> list;
    @FXML
    private JFXSpinner spinner;
    @FXML
    private StackPane failedPane;
    @FXML
    private StackPane emptyPane;
    @FXML
    private TransitionPane root;
    @FXML
    private JFXCheckBox chkRelease;
    @FXML
    private JFXCheckBox chkSnapshot;
    @FXML
    private JFXCheckBox chkOld;
    @FXML
    private JFXButton btnRefresh;
    @FXML
    private HBox checkPane;
    @FXML
    private ComponentList centrePane;
    @FXML
    private StackPane center;
    private VersionList<?> versionList;
    private CompletableFuture<?> executor;

    public VersionsPage(Navigation navigation, String title, String gameVersion, DownloadProvider downloadProvider, String libraryId, Runnable callback) {
        this.title = title;
        this.gameVersion = gameVersion;
        this.libraryId = libraryId;
        this.navigation = navigation;
        FXUtils.loadFXML((Node)this, "/assets/fxml/download/versions.fxml");
        this.versionList = downloadProvider.getVersionListById(libraryId);
        if (this.versionList.hasType()) {
            this.centrePane.getContent().setAll((Object[])new Node[]{this.checkPane, this.list});
        } else {
            this.centrePane.getContent().setAll((Object[])new Node[]{this.list});
        }
        ComponentList.setVgrow(this.list, Priority.ALWAYS);
        InvalidationListener listener = o -> this.list.getItems().setAll(this.loadVersions());
        this.chkRelease.selectedProperty().addListener(listener);
        this.chkSnapshot.selectedProperty().addListener(listener);
        this.chkOld.selectedProperty().addListener(listener);
        this.btnRefresh.setGraphic(ToolbarListPageSkin.wrap(SVG.refresh(Theme.blackFillBinding(), -1.0, -1.0)));
        this.list.setCellFactory(listView -> new ListCell<RemoteVersion>(){
            IconedTwoLineListItem content = new IconedTwoLineListItem();
            RipplerContainer ripplerContainer = new RipplerContainer((Node)this.content);
            StackPane pane = new StackPane();
            {
                this.pane.getStyleClass().add((Object)"md-list-cell");
                StackPane.setMargin((Node)this.content, (Insets)new Insets(10.0, 16.0, 10.0, 16.0));
                this.pane.getChildren().setAll((Object[])new Node[]{this.ripplerContainer});
            }

            public void updateItem(RemoteVersion remoteVersion, boolean empty) {
                super.updateItem((Object)remoteVersion, empty);
                if (empty) {
                    this.setGraphic(null);
                    return;
                }
                this.setGraphic((Node)this.pane);
                this.content.setTitle(remoteVersion.getSelfVersion());
                if (remoteVersion.getReleaseDate() != null) {
                    this.content.setSubtitle(Locales.DATE_TIME_FORMATTER.get().format(remoteVersion.getReleaseDate()));
                } else {
                    this.content.setSubtitle("");
                }
                if (remoteVersion instanceof GameRemoteVersion) {
                    switch (remoteVersion.getVersionType()) {
                        case RELEASE: {
                            this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.release")});
                            this.content.setImage(new Image("/assets/img/grass.png", 32.0, 32.0, false, true));
                            break;
                        }
                        case SNAPSHOT: {
                            this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.snapshot")});
                            this.content.setImage(new Image("/assets/img/command.png", 32.0, 32.0, false, true));
                            break;
                        }
                        default: {
                            this.content.getTags().setAll((Object[])new String[]{I18n.i18n("version.game.old")});
                            this.content.setImage(new Image("/assets/img/craft_table.png", 32.0, 32.0, false, true));
                            break;
                        }
                    }
                } else if (remoteVersion instanceof LiteLoaderRemoteVersion) {
                    this.content.setImage(new Image("/assets/img/chicken.png", 32.0, 32.0, false, true));
                    if (StringUtils.isNotBlank(this.content.getSubtitle())) {
                        this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                    } else {
                        this.content.setSubtitle(remoteVersion.getGameVersion());
                    }
                } else if (remoteVersion instanceof OptiFineRemoteVersion) {
                    this.content.setImage(new Image("/assets/img/command.png", 32.0, 32.0, false, true));
                    if (StringUtils.isNotBlank(this.content.getSubtitle())) {
                        this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                    } else {
                        this.content.setSubtitle(remoteVersion.getGameVersion());
                    }
                } else if (remoteVersion instanceof ForgeRemoteVersion) {
                    this.content.setImage(new Image("/assets/img/forge.png", 32.0, 32.0, false, true));
                    if (StringUtils.isNotBlank(this.content.getSubtitle())) {
                        this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                    } else {
                        this.content.setSubtitle(remoteVersion.getGameVersion());
                    }
                } else if (remoteVersion instanceof FabricRemoteVersion) {
                    this.content.setImage(new Image("/assets/img/fabric.png", 32.0, 32.0, false, true));
                    if (StringUtils.isNotBlank(this.content.getSubtitle())) {
                        this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                    } else {
                        this.content.setSubtitle(remoteVersion.getGameVersion());
                    }
                } else if (remoteVersion instanceof FabricAPIRemoteVersion) {
                    this.content.setImage(new Image("/assets/img/fabric.png", 32.0, 32.0, false, true));
                    if (StringUtils.isNotBlank(this.content.getSubtitle())) {
                        this.content.getTags().setAll((Object[])new String[]{remoteVersion.getGameVersion()});
                    } else {
                        this.content.setSubtitle(remoteVersion.getGameVersion());
                    }
                }
            }
        });
        this.list.setOnMouseClicked(e -> {
            if (this.list.getSelectionModel().getSelectedIndex() < 0) {
                return;
            }
            navigation.getSettings().put(libraryId, this.list.getSelectionModel().getSelectedItem());
            callback.run();
        });
        this.refresh();
    }

    private List<RemoteVersion> loadVersions() {
        return this.versionList.getVersions(this.gameVersion).stream().filter(it -> {
            switch (it.getVersionType()) {
                case RELEASE: {
                    return this.chkRelease.isSelected();
                }
                case SNAPSHOT: {
                    return this.chkSnapshot.isSelected();
                }
                case OLD: {
                    return this.chkOld.isSelected();
                }
            }
            return true;
        }).sorted().collect(Collectors.toList());
    }

    @Override
    public void refresh() {
        VersionList<?> currentVersionList = this.versionList;
        this.root.setContent((Node)this.spinner, ContainerAnimations.FADE.getAnimationProducer());
        this.executor = currentVersionList.refreshAsync(this.gameVersion).whenComplete((result, exception) -> {
            if (exception == null) {
                List<RemoteVersion> items = this.loadVersions();
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    if (currentVersionList.getVersions(this.gameVersion).isEmpty()) {
                        this.root.setContent((Node)this.emptyPane, ContainerAnimations.FADE.getAnimationProducer());
                    } else {
                        if (items.isEmpty()) {
                            this.chkRelease.setSelected(true);
                            this.chkSnapshot.setSelected(true);
                            this.chkOld.setSelected(true);
                        } else {
                            this.list.getItems().setAll((Collection)items);
                        }
                        this.root.setContent((Node)this.center, ContainerAnimations.FADE.getAnimationProducer());
                    }
                });
            } else {
                Logging.LOG.log(Level.WARNING, "Failed to fetch versions list", (Throwable)exception);
                Platform.runLater(() -> {
                    if (this.versionList != currentVersionList) {
                        return;
                    }
                    this.root.setContent((Node)this.failedPane, ContainerAnimations.FADE.getAnimationProducer());
                });
            }
            System.gc();
        });
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        settings.remove(this.libraryId);
        if (this.executor != null) {
            this.executor.cancel(true);
        }
    }

    @FXML
    private void onRefresh() {
        this.refresh();
    }

    @FXML
    private void onBack() {
        this.navigation.onPrev(true);
    }

    @FXML
    private void onSponsor() {
        HMCLService.openRedirectLink("bmclapi_sponsor");
    }
}

