/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.export;

import com.jfoenix.controls.JFXTreeView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.NoneMultipleSelectionModel;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class ModpackFileSelectionPage
extends StackPane
implements WizardPage {
    private final WizardController controller;
    private final String version;
    private final ModAdviser adviser;
    @FXML
    private JFXTreeView<String> treeView;
    private final CheckBoxTreeItem<String> rootNode;
    public static final String MODPACK_FILE_SELECTION = "modpack.accepted";
    private static final Map<String, String> TRANSLATION = Lang.mapOf(Pair.pair("minecraft/hmclversion.cfg", I18n.i18n("modpack.files.hmclversion_cfg")), Pair.pair("minecraft/servers.dat", I18n.i18n("modpack.files.servers_dat")), Pair.pair("minecraft/saves", I18n.i18n("modpack.files.saves")), Pair.pair("minecraft/mods", I18n.i18n("modpack.files.mods")), Pair.pair("minecraft/config", I18n.i18n("modpack.files.config")), Pair.pair("minecraft/liteconfig", I18n.i18n("modpack.files.liteconfig")), Pair.pair("minecraft/resourcepacks", I18n.i18n("modpack.files.resourcepacks")), Pair.pair("minecraft/resources", I18n.i18n("modpack.files.resourcepacks")), Pair.pair("minecraft/options.txt", I18n.i18n("modpack.files.options_txt")), Pair.pair("minecraft/optionsshaders.txt", I18n.i18n("modpack.files.optionsshaders_txt")), Pair.pair("minecraft/mods/VoxelMods", I18n.i18n("modpack.files.mods.voxelmods")), Pair.pair("minecraft/dumps", I18n.i18n("modpack.files.dumps")), Pair.pair("minecraft/blueprints", I18n.i18n("modpack.files.blueprints")), Pair.pair("minecraft/scripts", I18n.i18n("modpack.files.scripts")));

    public ModpackFileSelectionPage(WizardController controller, Profile profile, String version, ModAdviser adviser) {
        this.controller = controller;
        this.version = version;
        this.adviser = adviser;
        FXUtils.loadFXML((Node)this, "/assets/fxml/modpack/selection.fxml");
        this.rootNode = this.getTreeItem(profile.getRepository().getRunDirectory(version), "minecraft");
        this.treeView.setRoot((TreeItem)this.rootNode);
        this.treeView.setSelectionModel(new NoneMultipleSelectionModel());
    }

    private CheckBoxTreeItem<String> getTreeItem(File file, String basePath) {
        if (!file.exists()) {
            return null;
        }
        ModAdviser.ModSuggestion state = ModAdviser.ModSuggestion.SUGGESTED;
        if (basePath.length() > "minecraft/".length()) {
            state = this.adviser.advise(StringUtils.substringAfter(basePath, "minecraft/") + (file.isDirectory() ? "/" : ""), file.isDirectory());
            if (file.isFile() && Objects.equals(FileUtils.getNameWithoutExtension(file), this.version)) {
                state = ModAdviser.ModSuggestion.HIDDEN;
            }
            if (file.isDirectory() && Objects.equals(file.getName(), this.version + "-natives")) {
                state = ModAdviser.ModSuggestion.HIDDEN;
            }
            if (state == ModAdviser.ModSuggestion.HIDDEN) {
                return null;
            }
        }
        CheckBoxTreeItem node = new CheckBoxTreeItem((Object)StringUtils.substringAfterLast(basePath, "/"));
        if (state == ModAdviser.ModSuggestion.SUGGESTED) {
            node.setSelected(true);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File it : files) {
                    CheckBoxTreeItem<String> subNode = this.getTreeItem(it, basePath + "/" + it.getName());
                    if (subNode == null) continue;
                    node.setSelected(subNode.isSelected() || node.isSelected());
                    if (!subNode.isSelected()) {
                        node.setIndeterminate(true);
                    }
                    node.getChildren().add(subNode);
                }
            }
            if (!node.isSelected()) {
                node.setIndeterminate(false);
            }
            if (node.getChildren().isEmpty()) {
                return null;
            }
        }
        HBox graphic = new HBox();
        CheckBox checkBox = new CheckBox();
        checkBox.selectedProperty().bindBidirectional((Property)node.selectedProperty());
        checkBox.indeterminateProperty().bindBidirectional((Property)node.indeterminateProperty());
        graphic.getChildren().add((Object)checkBox);
        if (TRANSLATION.containsKey(basePath)) {
            Label comment = new Label();
            comment.setText(TRANSLATION.get(basePath));
            comment.setStyle("-fx-text-fill: gray;");
            comment.setMouseTransparent(true);
            graphic.getChildren().add((Object)comment);
        }
        graphic.setPickOnBounds(false);
        node.setExpanded("minecraft".equals(basePath));
        node.setGraphic((Node)graphic);
        return node;
    }

    private void getFilesNeeded(CheckBoxTreeItem<String> node, String basePath, List<String> list) {
        if (node == null) {
            return;
        }
        if (node.isSelected() || node.isIndeterminate()) {
            if (basePath.length() > "minecraft/".length()) {
                list.add(StringUtils.substringAfter(basePath, "minecraft/"));
            }
            for (TreeItem child : node.getChildren()) {
                if (!(child instanceof CheckBoxTreeItem)) continue;
                this.getFilesNeeded((CheckBoxTreeItem<String>)((CheckBoxTreeItem)child), basePath + "/" + (String)child.getValue(), list);
            }
        }
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
        this.controller.getSettings().remove(MODPACK_FILE_SELECTION);
    }

    @FXML
    private void onNext() {
        ArrayList<String> list = new ArrayList<String>();
        this.getFilesNeeded(this.rootNode, "minecraft", list);
        this.controller.getSettings().put(MODPACK_FILE_SELECTION, list);
        this.controller.onFinish();
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.wizard.step.2.title");
    }
}

