/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ToggleGroup;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Settings;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.main.SettingsView;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.upgrade.UpdateChannel;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.upgrade.UpdateHandler;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.Locales;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;

public final class SettingsPage
extends SettingsView {
    private InvalidationListener updateListener;

    public SettingsPage() {
        FXUtils.smoothScrolling(this.scroll);
        this.cboLanguage.getItems().setAll(Locales.LOCALES);
        ExtendedProperties.selectedItemPropertyFor(this.cboLanguage).bindBidirectional(ConfigHolder.config().localizationProperty());
        this.fileCommonLocation.selectedDataProperty().bindBidirectional(ConfigHolder.config().commonDirTypeProperty());
        this.fileCommonLocationSublist.subtitleProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> Optional.ofNullable(Settings.instance().getCommonDirectory()).orElse(I18n.i18n("launcher.cache_directory.disabled")), (Observable[])new Observable[]{ConfigHolder.config().commonDirectoryProperty(), ConfigHolder.config().commonDirTypeProperty()}));
        FXUtils.installFastTooltip((Node)this.btnUpdate, I18n.i18n("update.tooltip"));
        this.updateListener = any -> {
            this.btnUpdate.setVisible(UpdateChecker.isOutdated());
            if (UpdateChecker.isOutdated()) {
                this.lblUpdateSub.setText(I18n.i18n("update.newest_version", UpdateChecker.getLatestVersion().getVersion()));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"update-label"});
                this.lblUpdate.setText(I18n.i18n("update.found"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[]{"update-label"});
            } else if (UpdateChecker.isCheckingUpdate()) {
                this.lblUpdateSub.setText(I18n.i18n("update.checking"));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                this.lblUpdate.setText(I18n.i18n("update"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[0]);
            } else {
                this.lblUpdateSub.setText(I18n.i18n("update.latest"));
                this.lblUpdateSub.getStyleClass().setAll((Object[])new String[]{"subtitle-label"});
                this.lblUpdate.setText(I18n.i18n("update"));
                this.lblUpdate.getStyleClass().setAll((Object[])new String[0]);
            }
        };
        UpdateChecker.latestVersionProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.outdatedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        UpdateChecker.checkingUpdateProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.updateListener));
        this.updateListener.invalidated(null);
        ToggleGroup updateChannelGroup = new ToggleGroup();
        this.chkUpdateDev.setToggleGroup(updateChannelGroup);
        this.chkUpdateDev.setUserData((Object)UpdateChannel.DEVELOPMENT);
        this.chkUpdateStable.setToggleGroup(updateChannelGroup);
        this.chkUpdateStable.setUserData((Object)UpdateChannel.STABLE);
        ObjectProperty<UpdateChannel> updateChannel = ExtendedProperties.selectedItemPropertyFor(updateChannelGroup, UpdateChannel.class);
        updateChannel.set((Object)UpdateChannel.getChannel());
        updateChannel.addListener((a, b, newValue) -> UpdateChecker.requestCheckUpdate(newValue));
    }

    @Override
    protected void onUpdate() {
        RemoteVersion target = UpdateChecker.getLatestVersion();
        if (target == null) {
            return;
        }
        UpdateHandler.updateFrom(target);
    }

    @Override
    protected void onExportLogs() {
        Lang.thread(() -> {
            Path logFile = Paths.get("hmcl-exported-logs-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ss")) + ".log", new String[0]).toAbsolutePath();
            Logging.LOG.info("Exporting logs to " + logFile);
            try {
                Files.write(logFile, Logging.getRawLogs(), new OpenOption[0]);
            }
            catch (IOException e) {
                Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.failed") + "\n" + e, null, MessageDialogPane.MessageType.ERROR));
                Logging.LOG.log(Level.WARNING, "Failed to export logs", e);
                return;
            }
            Platform.runLater(() -> Controllers.dialog(I18n.i18n("settings.launcher.launcher_log.export.success", logFile)));
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(logFile.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    protected void onSponsor() {
        FXUtils.openLink("https://hmcl.huangyuhui.net/api/redirect/sponsor");
    }

    @Override
    protected void clearCacheDirectory() {
        FileUtils.cleanDirectoryQuietly(new File(Settings.instance().getCommonDirectory(), "cache"));
    }
}

