/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerManager;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public class LocalServerBroadcaster
implements Runnable {
    private final int port;
    private final MultiplayerManager.CatoSession session;

    public LocalServerBroadcaster(int port, MultiplayerManager.CatoSession session) {
        this.port = port;
        this.session = session;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        InetAddress broadcastAddress;
        DatagramSocket socket;
        try {
            socket = new DatagramSocket();
            broadcastAddress = InetAddress.getByName("224.0.2.60");
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to create datagram socket", e);
            return;
        }
        while (this.session.isRunning()) {
            try {
                byte[] data = String.format("[MOTD]%s[/MOTD][AD]%d[/AD]", I18n.i18n("multiplayer.session.name.motd", this.session.getName()), this.port).getBytes(StandardCharsets.UTF_8);
                DatagramPacket packet = new DatagramPacket(data, 0, data.length, broadcastAddress, 4445);
                socket.send(packet);
                Logging.LOG.finest("Broadcast server 0.0.0.0:" + this.port);
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Failed to send motd packet", e);
            }
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException ignored) {
                return;
            }
        }
        socket.close();
    }
}

