/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.util.gson.JsonSubtype;
import org.jackhuang.hmcl.util.gson.JsonType;

public final class MultiplayerChannel {
    private MultiplayerChannel() {
    }

    public static String verifyJson(String jsonString) {
        if (jsonString.indexOf(13) >= 0 || jsonString.indexOf(10) >= 0) {
            throw new IllegalArgumentException();
        }
        return jsonString;
    }

    public static class CatoClient
    extends Event {
        private final String username;

        public CatoClient(Object source, String username) {
            super(source);
            this.username = username;
        }

        public String getUsername() {
            return this.username;
        }
    }

    public static class HandshakeRequest
    extends Request {
    }

    public static class HandshakeResponse
    extends Response {
    }

    public static class JoinRequest
    extends Request {
        private final String clientVersion;
        private final String username;

        public JoinRequest(String clientVersion, String username) {
            this.clientVersion = clientVersion;
            this.username = username;
        }

        public String getClientVersion() {
            return this.clientVersion;
        }

        public String getUsername() {
            return this.username;
        }
    }

    public static class JoinResponse
    extends Response {
        private final String sessionName;
        private final int port;

        public JoinResponse(String sessionName, int port) {
            this.sessionName = sessionName;
            this.port = port;
        }

        public String getSessionName() {
            return this.sessionName;
        }

        public int getPort() {
            return this.port;
        }
    }

    public static class KeepAliveRequest
    extends Request {
        private final long timestamp;

        public KeepAliveRequest(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class KeepAliveResponse
    extends Response {
        private final long timestamp;

        public KeepAliveResponse(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class KickResponse
    extends Response {
        private final String msg;
        public static final String VERSION_NOT_MATCHED = "version_not_matched";
        public static final String KICKED = "kicked";
        public static final String JOIN_ACEEPTANCE_TIMEOUT = "join_acceptance_timeout";

        public KickResponse(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    @JsonType(property="type", subtypes={@JsonSubtype(clazz=HandshakeRequest.class, name="handshake"), @JsonSubtype(clazz=JoinRequest.class, name="join"), @JsonSubtype(clazz=KeepAliveRequest.class, name="keepalive")})
    public static class Request {
    }

    @JsonType(property="type", subtypes={@JsonSubtype(clazz=HandshakeResponse.class, name="handshake"), @JsonSubtype(clazz=JoinResponse.class, name="join"), @JsonSubtype(clazz=KeepAliveResponse.class, name="keepalive"), @JsonSubtype(clazz=KickResponse.class, name="kick")})
    public static class Response {
    }
}

