/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialogLayout;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageAware;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.multiplayer.CreateMultiplayerRoomDialog;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerChannel;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerManager;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerPageSkin;
import org.jackhuang.hmcl.util.HMCLService;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Result;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.ChecksumMismatchException;
import org.jetbrains.annotations.Nullable;

public class MultiplayerPage
extends DecoratorAnimatedPage
implements DecoratorPage,
PageAware {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("multiplayer")));
    private final ObjectProperty<MultiplayerManager.State> multiplayerState = new SimpleObjectProperty((Object)MultiplayerManager.State.DISCONNECTED);
    private final ReadOnlyStringWrapper token = new ReadOnlyStringWrapper();
    private final ReadOnlyObjectWrapper<@Nullable Result<DiscoveryInfo>> natState = new ReadOnlyObjectWrapper();
    private final ReadOnlyIntegerWrapper gamePort = new ReadOnlyIntegerWrapper(-1);
    private final ReadOnlyObjectWrapper<MultiplayerManager.CatoSession> session = new ReadOnlyObjectWrapper();
    private final ObservableList<MultiplayerChannel.CatoClient> clients = FXCollections.observableArrayList();
    private Consumer<MultiplayerManager.CatoExitEvent> onExit;
    private Consumer<MultiplayerManager.CatoIdEvent> onIdGenerated;
    private Consumer<Event> onPeerConnected;

    public MultiplayerPage() {
        this.testNAT();
    }

    @Override
    public void onPageShown() {
        this.checkAgreement(this::downloadCatoIfNecessary);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MultiplayerPageSkin(this);
    }

    public ObservableList<MultiplayerChannel.CatoClient> getClients() {
        return this.clients;
    }

    public MultiplayerManager.State getMultiplayerState() {
        return (MultiplayerManager.State)((Object)this.multiplayerState.get());
    }

    public ObjectProperty<MultiplayerManager.State> multiplayerStateProperty() {
        return this.multiplayerState;
    }

    public void setMultiplayerState(MultiplayerManager.State multiplayerState) {
        this.multiplayerState.set((Object)multiplayerState);
    }

    public Result<DiscoveryInfo> getNatState() {
        return (Result)this.natState.get();
    }

    public ReadOnlyObjectProperty<Result<DiscoveryInfo>> natStateProperty() {
        return this.natState.getReadOnlyProperty();
    }

    public String getToken() {
        return this.token.get();
    }

    public ReadOnlyStringProperty tokenProperty() {
        return this.token.getReadOnlyProperty();
    }

    public int getGamePort() {
        return this.gamePort.get();
    }

    public ReadOnlyIntegerProperty gamePortProperty() {
        return this.gamePort.getReadOnlyProperty();
    }

    public MultiplayerManager.CatoSession getSession() {
        return (MultiplayerManager.CatoSession)this.session.get();
    }

    public ReadOnlyObjectProperty<MultiplayerManager.CatoSession> sessionProperty() {
        return this.session.getReadOnlyProperty();
    }

    private void testNAT() {
        Task.supplyAsync(() -> {
            DiscoveryTest tester = new DiscoveryTest(null, 0, "stun.miwifi.com", 3478);
            return tester.test();
        }).whenComplete(Schedulers.javafx(), (info, exception) -> {
            if (exception == null) {
                this.natState.set(Result.ok(info));
            } else {
                this.natState.set(Result.error());
            }
            Logging.LOG.log(Level.INFO, "Nat test result " + MultiplayerPageSkin.getNATType((Result)this.natState.get()), exception);
        }).start();
    }

    private void checkAgreement(Runnable runnable) {
        if (ConfigHolder.globalConfig().getMultiplayerAgreementVersion() < 2) {
            JFXDialogLayout agreementPane = new JFXDialogLayout();
            agreementPane.setHeading(new Node[]{new Label(I18n.i18n("launcher.agreement"))});
            agreementPane.setBody(new Node[]{new Label(I18n.i18n("multiplayer.agreement.prompt"))});
            JFXHyperlink agreementLink = new JFXHyperlink(I18n.i18n("launcher.agreement"));
            agreementLink.setOnAction(e -> HMCLService.openRedirectLink("multiplayer-agreement"));
            JFXButton yesButton = new JFXButton(I18n.i18n("launcher.agreement.accept"));
            yesButton.getStyleClass().add((Object)"dialog-accept");
            yesButton.setOnAction(e -> {
                ConfigHolder.globalConfig().setMultiplayerAgreementVersion(2);
                runnable.run();
                agreementPane.fireEvent(new DialogCloseEvent());
            });
            JFXButton noButton = new JFXButton(I18n.i18n("launcher.agreement.decline"));
            noButton.getStyleClass().add((Object)"dialog-cancel");
            noButton.setOnAction(e -> {
                agreementPane.fireEvent(new DialogCloseEvent());
                this.fireEvent(new PageCloseEvent());
            });
            agreementPane.setActions(new Node[]{agreementLink, yesButton, noButton});
            Controllers.dialog((Region)agreementPane);
        } else {
            runnable.run();
        }
    }

    private void downloadCatoIfNecessary() {
        if (StringUtils.isBlank(MultiplayerManager.getCatoPath())) {
            Controllers.dialog(I18n.i18n("multiplayer.download.unsupported"), I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR);
            this.fireEvent(new PageCloseEvent());
            return;
        }
        if (!MultiplayerManager.getCatoExecutable().toFile().exists()) {
            this.setDisabled(true);
            TaskExecutor executor = MultiplayerManager.downloadCato().whenComplete(Schedulers.javafx(), exception -> {
                this.setDisabled(false);
                if (exception != null) {
                    if (exception instanceof CancellationException) {
                        Controllers.showToast(I18n.i18n("message.cancelled"));
                    } else {
                        Controllers.dialog(DownloadProviders.localizeErrorMessage(exception), I18n.i18n("install.failed.downloading"), MessageDialogPane.MessageType.ERROR);
                        this.fireEvent(new PageCloseEvent());
                    }
                } else {
                    Controllers.showToast(I18n.i18n("multiplayer.download.success"));
                }
            }).executor();
            Controllers.taskDialog(executor, I18n.i18n("multiplayer.download"));
            executor.start();
        } else {
            this.setDisabled(false);
        }
    }

    public void copyInvitationCode() {
        if (this.getSession() == null || !this.getSession().isReady() || this.gamePort.get() < 0 || this.getMultiplayerState() != MultiplayerManager.State.MASTER) {
            throw new IllegalStateException("CatoSession not ready");
        }
        FXUtils.copyText(this.getSession().generateInvitationCode(this.getSession().getServer().getPort()));
    }

    public void createRoom() {
        if (this.getSession() != null || this.getMultiplayerState() != MultiplayerManager.State.DISCONNECTED) {
            throw new IllegalStateException("CatoSession already ready");
        }
        Controllers.dialog((Region)new CreateMultiplayerRoomDialog((result, resolve, reject) -> {
            int gamePort = result.getServer().getAd();
            boolean isStaticToken = StringUtils.isNotBlank(ConfigHolder.globalConfig().getMultiplayerToken());
            ((CompletableFuture)MultiplayerManager.createSession(ConfigHolder.globalConfig().getMultiplayerToken(), result.getServer().getMotd(), gamePort, result.isAllowAllJoinRequests()).thenAcceptAsync(session -> {
                session.getServer().setOnClientAdding((client, resolveClient, rejectClient) -> FXUtils.runInFX(() -> Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("multiplayer.session.create.join.prompt", client.getUsername()), I18n.i18n("multiplayer.session.create.join"), MessageDialogPane.MessageType.INFO).yesOrNo(resolveClient, () -> rejectClient.accept("join_acceptance_timeout")).cancelOnTimeout(30000L).build())));
                session.getServer().onClientAdded().register(event -> FXUtils.runInFX(() -> this.clients.add(event)));
                session.getServer().onClientDisconnected().register(event -> FXUtils.runInFX(() -> this.clients.remove(event)));
                this.initCatoSession((MultiplayerManager.CatoSession)session);
                this.gamePort.set(gamePort);
                this.setMultiplayerState(MultiplayerManager.State.MASTER);
                resolve.run();
            }, Platform::runLater)).exceptionally(throwable -> {
                reject.accept(this.localizeCreateErrorMessage((Throwable)throwable, isStaticToken));
                return null;
            });
        }));
    }

    public void joinRoom() {
        if (this.getSession() != null || this.getMultiplayerState() != MultiplayerManager.State.DISCONNECTED) {
            throw new IllegalStateException("CatoSession already ready");
        }
        Controllers.prompt(new PromptDialogPane.Builder(I18n.i18n("multiplayer.session.join"), (result, resolve, reject) -> {
            int localPort;
            MultiplayerManager.Invitation invitation;
            final PromptDialogPane.Builder.HintQuestion hintQuestion = (PromptDialogPane.Builder.HintQuestion)result.get(0);
            boolean isStaticToken = StringUtils.isNotBlank(ConfigHolder.globalConfig().getMultiplayerToken());
            String invitationCode = (String)((PromptDialogPane.Builder.StringQuestion)result.get(1)).getValue();
            try {
                invitation = MultiplayerManager.parseInvitationCode(invitationCode);
            }
            catch (Exception e) {
                Logging.LOG.log(Level.WARNING, "Failed to join session", e);
                reject.accept(I18n.i18n("multiplayer.session.join.invitation_code.error"));
                return;
            }
            try {
                localPort = MultiplayerManager.findAvailablePort();
            }
            catch (Exception e) {
                reject.accept(I18n.i18n("multiplayer.session.join.port.error"));
                return;
            }
            try {
                ((CompletableFuture)MultiplayerManager.joinSession(ConfigHolder.globalConfig().getMultiplayerToken(), invitation.getId(), ConfigHolder.globalConfig().isMultiplayerRelay() && (StringUtils.isNotBlank(ConfigHolder.globalConfig().getMultiplayerToken()) || StringUtils.isNotBlank(System.getProperty("hmcl.multiplayer.relay"))) ? MultiplayerManager.Mode.BRIDGE : MultiplayerManager.Mode.P2P, invitation.getChannelPort(), localPort, new MultiplayerManager.JoinSessionHandler(){

                    @Override
                    public void onWaitingForJoinResponse() {
                        FXUtils.runInFX(() -> hintQuestion.setQuestion(I18n.i18n("multiplayer.session.join.wait")));
                    }
                }).thenAcceptAsync(session -> {
                    this.initCatoSession((MultiplayerManager.CatoSession)session);
                    AtomicBoolean kicked = new AtomicBoolean();
                    session.getClient().onDisconnected().register(() -> FXUtils.runInFX(() -> {
                        this.stopCatoSession();
                        if (!kicked.get()) {
                            Controllers.dialog(I18n.i18n("multiplayer.session.join.lost_connection"));
                        }
                    }));
                    session.getClient().onKicked().register(kickedEvent -> FXUtils.runInFX(() -> {
                        kicked.set(true);
                        Controllers.dialog(I18n.i18n("multiplayer.session.join.kicked", this.localizeKickMessage(kickedEvent.getReason())));
                    }));
                    this.gamePort.set(session.getClient().getGamePort());
                    this.setMultiplayerState(MultiplayerManager.State.SLAVE);
                    resolve.run();
                }, Platform::runLater)).exceptionally(throwable -> {
                    reject.accept(this.localizeJoinErrorMessage((Throwable)throwable, isStaticToken));
                    return null;
                });
            }
            catch (MultiplayerManager.IncompatibleCatoVersionException e) {
                reject.accept(I18n.i18n("multiplayer.session.join.invitation_code.version"));
            }
        }).addQuestion(new PromptDialogPane.Builder.HintQuestion(I18n.i18n("multiplayer.session.join.hint"))).addQuestion(new PromptDialogPane.Builder.StringQuestion(I18n.i18n("multiplayer.session.join.invitation_code"), "", new RequiredValidator())));
    }

    private String localizeKickMessage(String message) {
        if ("version_not_matched".equals(message)) {
            return I18n.i18n("multiplayer.session.join.kicked.version_not_matched");
        }
        if ("kicked".equals(message)) {
            return I18n.i18n("multiplayer.session.join.kicked.kicked");
        }
        if ("join_acceptance_timeout".equals(message)) {
            return I18n.i18n("multiplayer.session.join.kicked.join_acceptance_timeout");
        }
        return message;
    }

    private String localizeErrorMessage(Throwable t, boolean isStaticToken, Function<Throwable, String> fallback) {
        Throwable e = Lang.resolveException(t);
        if (e instanceof CancellationException) {
            Logging.LOG.info("Connection rejected by the server");
            return I18n.i18n("message.cancelled");
        }
        if (e instanceof MultiplayerManager.KickedException) {
            Logging.LOG.info("Kicked by server");
            return I18n.i18n("multiplayer.session.join.kicked", this.localizeKickMessage(((MultiplayerManager.KickedException)e).getReason()));
        }
        if (e instanceof MultiplayerManager.CatoAlreadyStartedException) {
            Logging.LOG.info("Cato already started");
            return I18n.i18n("multiplayer.session.error.already_started");
        }
        if (e instanceof MultiplayerManager.CatoNotExistsException) {
            Logging.LOG.log(Level.WARNING, "Cato not found " + ((MultiplayerManager.CatoNotExistsException)e).getFile(), e);
            return I18n.i18n("multiplayer.session.error.file_not_found");
        }
        if (e instanceof MultiplayerManager.JoinRequestTimeoutException) {
            Logging.LOG.info("Cato already started");
            return I18n.i18n("multiplayer.session.join.wait_timeout");
        }
        if (e instanceof MultiplayerManager.ConnectionErrorException) {
            Logging.LOG.info("Failed to establish connection with server");
            return I18n.i18n("multiplayer.session.join.error.connection");
        }
        if (e instanceof MultiplayerManager.CatoExitTimeoutException) {
            Logging.LOG.info("Cato failed to connect to main net");
            if (isStaticToken) {
                return I18n.i18n("multiplayer.exit.timeout.static_token");
            }
            return I18n.i18n("multiplayer.exit.timeout.dynamic_token");
        }
        if (e instanceof MultiplayerManager.CatoExitException) {
            Logging.LOG.info("Cato exited accidentally");
            if (!((MultiplayerManager.CatoExitException)e).isReady()) {
                return I18n.i18n("multiplayer.exit.before_ready");
            }
            return I18n.i18n("multiplayer.exit.after_ready");
        }
        if (e instanceof ChecksumMismatchException) {
            return I18n.i18n("exception.artifact_malformed");
        }
        return fallback.apply(e);
    }

    private String localizeCreateErrorMessage(Throwable t, boolean isStaticToken) {
        return this.localizeErrorMessage(t, isStaticToken, e -> {
            Logging.LOG.log(Level.WARNING, "Failed to create session", (Throwable)e);
            if (isStaticToken) {
                return I18n.i18n("multiplayer.session.create.error.static_token") + e.getLocalizedMessage();
            }
            return I18n.i18n("multiplayer.session.create.error.dynamic_token") + e.getLocalizedMessage();
        });
    }

    private String localizeJoinErrorMessage(Throwable t, boolean isStaticToken) {
        return this.localizeErrorMessage(t, isStaticToken, e -> {
            Logging.LOG.log(Level.WARNING, "Failed to join session", (Throwable)e);
            return I18n.i18n("multiplayer.session.join.error");
        });
    }

    public void kickPlayer(MultiplayerChannel.CatoClient client) {
        if (this.getSession() == null || !this.getSession().isReady() || this.getMultiplayerState() != MultiplayerManager.State.MASTER) {
            throw new IllegalStateException("CatoSession not ready");
        }
        Controllers.confirm(I18n.i18n("multiplayer.session.create.members.kick.prompt"), I18n.i18n("multiplayer.session.create.members.kick"), MessageDialogPane.MessageType.WARNING, () -> this.getSession().getServer().kickPlayer(client), null);
    }

    public void closeRoom() {
        if (this.getSession() == null || !this.getSession().isReady() || this.getMultiplayerState() != MultiplayerManager.State.MASTER) {
            throw new IllegalStateException("CatoSession not ready");
        }
        Controllers.confirm(I18n.i18n("multiplayer.session.close.warning"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, this::stopCatoSession, null);
    }

    public void quitRoom() {
        if (this.getSession() == null || !this.getSession().isReady() || this.getMultiplayerState() != MultiplayerManager.State.SLAVE) {
            throw new IllegalStateException("CatoSession not ready");
        }
        Controllers.confirm(I18n.i18n("multiplayer.session.quit.warning"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.WARNING, this::stopCatoSession, null);
    }

    public void cancelRoom() {
        if (this.getSession() == null || this.getSession().isReady() || this.getMultiplayerState() != MultiplayerManager.State.CONNECTING) {
            throw new IllegalStateException("CatoSession not existing or already ready");
        }
        this.stopCatoSession();
    }

    private void initCatoSession(MultiplayerManager.CatoSession session) {
        FXUtils.runInFX(() -> {
            this.onExit = session.onExit().registerWeak(this::onCatoExit);
            this.onIdGenerated = session.onIdGenerated().registerWeak(this::onCatoIdGenerated);
            this.onPeerConnected = session.onPeerConnected().registerWeak(this::onCatoPeerConnected);
            this.clients.clear();
            this.session.set((Object)session);
        });
    }

    private void stopCatoSession() {
        if (this.getSession() != null) {
            this.getSession().stop();
        }
        this.clearCatoSession();
    }

    private void clearCatoSession() {
        this.session.set(null);
        this.token.set(null);
        this.gamePort.set(-1);
        this.multiplayerState.set((Object)MultiplayerManager.State.DISCONNECTED);
    }

    private void onCatoExit(MultiplayerManager.CatoExitEvent event) {
        FXUtils.runInFX(() -> {
            boolean ready = ((MultiplayerManager.CatoSession)event.getSource()).isReady();
            switch (event.getExitCode()) {
                case 0: {
                    break;
                }
                case 10: {
                    Controllers.dialog(I18n.i18n("multiplayer.session.expired"));
                    break;
                }
                case 1: {
                    if (ready) break;
                    Controllers.dialog(I18n.i18n("multiplayer.exit.timeout"));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (!((MultiplayerManager.CatoSession)event.getSource()).isReady()) {
                        Controllers.dialog(I18n.i18n("multiplayer.exit.before_ready", event.getExitCode()));
                        break;
                    }
                    Controllers.dialog(I18n.i18n("multiplayer.exit.after_ready", event.getExitCode()));
                }
            }
            this.clearCatoSession();
        });
    }

    private void onCatoPeerConnected(Event event) {
        FXUtils.runInFX(() -> {});
    }

    private void onCatoIdGenerated(MultiplayerManager.CatoIdEvent event) {
        FXUtils.runInFX(() -> {
            this.token.set(event.getId());
            this.setMultiplayerState(((MultiplayerManager.CatoSession)event.getSource()).getType());
        });
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }
}

