/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.multiplayer;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPasswordField;
import de.javawi.jstun.test.DiscoveryInfo;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.HintPane;
import org.jackhuang.hmcl.ui.construct.JFXHyperlink;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerChannel;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerManager;
import org.jackhuang.hmcl.ui.multiplayer.MultiplayerPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.HMCLService;
import org.jackhuang.hmcl.util.Result;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;
import org.jetbrains.annotations.Nullable;

public class MultiplayerPageSkin
extends DecoratorAnimatedPage.DecoratorAnimatedPageSkin<MultiplayerPage> {
    private ObservableList<Node> clients;

    protected MultiplayerPageSkin(MultiplayerPage control) {
        super(control);
        VBox roomPane = new VBox();
        AdvancedListItem createRoomItem = new AdvancedListItem();
        createRoomItem.setTitle(I18n.i18n("multiplayer.session.create"));
        createRoomItem.setLeftGraphic(VersionPage.wrap(SVG::plusCircleOutline));
        createRoomItem.setActionButtonVisible(false);
        createRoomItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.createRoom()));
        AdvancedListItem joinRoomItem = new AdvancedListItem();
        joinRoomItem.setTitle(I18n.i18n("multiplayer.session.join"));
        joinRoomItem.setLeftGraphic(VersionPage.wrap(SVG::accountArrowRightOutline));
        joinRoomItem.setActionButtonVisible(false);
        joinRoomItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.joinRoom()));
        AdvancedListItem copyLinkItem = new AdvancedListItem();
        copyLinkItem.setTitle(I18n.i18n("multiplayer.session.copy_room_code"));
        copyLinkItem.setLeftGraphic(VersionPage.wrap(SVG::accountArrowRightOutline));
        copyLinkItem.setActionButtonVisible(false);
        copyLinkItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.copyInvitationCode()));
        AdvancedListItem cancelItem = new AdvancedListItem();
        cancelItem.setTitle(I18n.i18n("button.cancel"));
        cancelItem.setLeftGraphic(VersionPage.wrap(SVG::closeCircle));
        cancelItem.setActionButtonVisible(false);
        cancelItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.cancelRoom()));
        AdvancedListItem quitItem = new AdvancedListItem();
        quitItem.setTitle(I18n.i18n("multiplayer.session.quit"));
        quitItem.setLeftGraphic(VersionPage.wrap(SVG::closeCircle));
        quitItem.setActionButtonVisible(false);
        quitItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.quitRoom()));
        AdvancedListItem closeRoomItem = new AdvancedListItem();
        closeRoomItem.setTitle(I18n.i18n("multiplayer.session.close"));
        closeRoomItem.setLeftGraphic(VersionPage.wrap(SVG::closeCircle));
        closeRoomItem.setActionButtonVisible(false);
        closeRoomItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.closeRoom()));
        FXUtils.onChangeAndOperate(((MultiplayerPage)this.getSkinnable()).multiplayerStateProperty(), state -> {
            if (state == MultiplayerManager.State.DISCONNECTED) {
                roomPane.getChildren().setAll((Object[])new Node[]{createRoomItem, joinRoomItem});
            } else if (state == MultiplayerManager.State.CONNECTING) {
                roomPane.getChildren().setAll((Object[])new Node[]{cancelItem});
            } else if (state == MultiplayerManager.State.MASTER) {
                roomPane.getChildren().setAll((Object[])new Node[]{copyLinkItem, closeRoomItem});
            } else if (state == MultiplayerManager.State.SLAVE) {
                roomPane.getChildren().setAll((Object[])new Node[]{quitItem});
            }
        });
        AdvancedListBox sideBar = new AdvancedListBox().addNavigationDrawerItem(item -> {
            item.setTitle(I18n.i18n("version.launch"));
            item.setLeftGraphic(VersionPage.wrap(SVG::rocketLaunchOutline));
            item.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                Profile profile = Profiles.getSelectedProfile();
                Versions.launch(profile, profile.getSelectedVersion(), LauncherHelper::setKeep);
            }));
        }).startCategory(I18n.i18n("multiplayer.session")).add((Node)roomPane).startCategory(I18n.i18n("help")).addNavigationDrawerItem(item -> {
            item.setTitle(I18n.i18n("help"));
            item.setLeftGraphic(VersionPage.wrap(SVG::gamepad));
            item.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> FXUtils.openLink("https://hmcl.huangyuhui.net/help/launcher/multiplayer.html")));
        }).addNavigationDrawerItem(report -> {
            report.setTitle(I18n.i18n("feedback"));
            report.setLeftGraphic(VersionPage.wrap(SVG::messageAlertOutline));
            report.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> HMCLService.openRedirectLink("multiplayer-feedback")));
        });
        FXUtils.setLimitWidth((Region)sideBar, 200.0);
        this.setLeft(new Node[]{sideBar});
        VBox content = new VBox(16.0);
        content.setPadding(new Insets(10.0));
        content.setFillWidth(true);
        ScrollPane scrollPane = new ScrollPane((Node)content);
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        this.setCenter(new Node[]{scrollPane});
        ComponentList roomPane2 = new ComponentList();
        TransitionPane transitionPane = new TransitionPane();
        roomPane2.getContent().setAll((Object[])new Node[]{transitionPane});
        VBox disconnectedPane = new VBox(8.0);
        HintPane hintPane = new HintPane(MessageDialogPane.MessageType.INFO);
        hintPane.setText(I18n.i18n("multiplayer.state.disconnected.hint"));
        Label label = new Label(I18n.i18n("multiplayer.state.disconnected"));
        disconnectedPane.getChildren().setAll((Object[])new Node[]{hintPane, label});
        VBox connectingPane = new VBox(8.0);
        label = new Label(I18n.i18n("multiplayer.state.connecting"));
        connectingPane.getChildren().setAll((Object[])new Node[]{label});
        VBox masterPane = new VBox(8.0);
        HintPane masterHintPane = new HintPane();
        masterHintPane.setText(I18n.i18n("multiplayer.state.master.hint"));
        Label label2 = new Label(I18n.i18n("multiplayer.state.master"));
        label2.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> I18n.i18n("multiplayer.state.master", control.getSession() == null ? "" : control.getSession().getName(), control.getGamePort()), (Observable[])new Observable[]{control.gamePortProperty(), control.sessionProperty()}));
        Label membersLabel = new Label(I18n.i18n("multiplayer.session.create.members"));
        VBox clientsPane = new VBox(8.0);
        this.clients = MappedObservableList.create(control.getClients(), x$0 -> new ClientItem((MultiplayerChannel.CatoClient)x$0));
        Bindings.bindContent((List)clientsPane.getChildren(), this.clients);
        masterPane.getChildren().setAll((Object[])new Node[]{masterHintPane, label2, membersLabel, clientsPane});
        BorderPane slavePane = new BorderPane();
        HintPane slaveHintPane = new HintPane();
        slaveHintPane.setText(I18n.i18n("multiplayer.state.slave.hint"));
        slavePane.setTop((Node)slaveHintPane);
        Label label3 = new Label();
        label3.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> I18n.i18n("multiplayer.state.slave", control.getSession() == null ? "" : control.getSession().getName(), "0.0.0.0:" + control.getGamePort()), (Observable[])new Observable[]{control.sessionProperty(), control.gamePortProperty()}));
        BorderPane.setAlignment((Node)label3, (Pos)Pos.CENTER_LEFT);
        slavePane.setCenter((Node)label3);
        JFXButton copyButton = new JFXButton(I18n.i18n("multiplayer.state.slave.copy"));
        copyButton.setOnAction(e -> FXUtils.copyText("0.0.0.0:" + control.getGamePort()));
        slavePane.setRight((Node)copyButton);
        FXUtils.onChangeAndOperate(((MultiplayerPage)this.getSkinnable()).multiplayerStateProperty(), state -> {
            if (state == MultiplayerManager.State.DISCONNECTED) {
                transitionPane.setContent((Node)disconnectedPane, ContainerAnimations.NONE.getAnimationProducer());
            } else if (state == MultiplayerManager.State.CONNECTING) {
                transitionPane.setContent((Node)connectingPane, ContainerAnimations.NONE.getAnimationProducer());
            } else if (state == MultiplayerManager.State.MASTER) {
                transitionPane.setContent((Node)masterPane, ContainerAnimations.NONE.getAnimationProducer());
            } else if (state == MultiplayerManager.State.SLAVE) {
                transitionPane.setContent((Node)slavePane, ContainerAnimations.NONE.getAnimationProducer());
            }
        });
        ComponentList natDetectionPane = new ComponentList();
        GridPane pane = new GridPane();
        ColumnConstraints title = new ColumnConstraints();
        ColumnConstraints value = new ColumnConstraints();
        pane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{title, value});
        value.setFillWidth(true);
        value.setHgrow(Priority.ALWAYS);
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        HintPane hintPane2 = new HintPane(MessageDialogPane.MessageType.INFO);
        hintPane2.setText(I18n.i18n("multiplayer.nat.hint"));
        GridPane.setColumnSpan((Node)hintPane2, (Integer)2);
        pane.addRow(0, new Node[]{hintPane2});
        Label natResult = new Label();
        natResult.textProperty().bind(BindingMapping.of(((MultiplayerPage)this.getSkinnable()).natStateProperty()).map(MultiplayerPageSkin::getNATType));
        pane.addRow(1, new Node[]{new Label(I18n.i18n("multiplayer.nat.type")), natResult});
        natDetectionPane.getContent().add((Object)pane);
        ComponentList thanksPane = new ComponentList();
        GridPane gridPane = new GridPane();
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), FXUtils.getColumnHgrowing(), new ColumnConstraints()});
        gridPane.setVgap(8.0);
        gridPane.setHgap(16.0);
        JFXPasswordField tokenField = new JFXPasswordField();
        tokenField.textProperty().bindBidirectional((Property)ConfigHolder.globalConfig().multiplayerTokenProperty());
        tokenField.setPromptText(I18n.i18n("multiplayer.session.create.token.prompt"));
        JFXHyperlink applyLink = new JFXHyperlink(I18n.i18n("multiplayer.session.create.token.apply"));
        applyLink.setOnAction(e -> HMCLService.openRedirectLink("multiplayer-static-token"));
        gridPane.addRow(0, new Node[]{new Label(I18n.i18n("multiplayer.session.create.token")), tokenField, applyLink});
        OptionToggleButton relay = new OptionToggleButton();
        relay.disableProperty().bind((ObservableValue)tokenField.textProperty().isEmpty());
        relay.selectedProperty().bindBidirectional((Property)ConfigHolder.globalConfig().multiplayerRelayProperty());
        relay.setTitle(I18n.i18n("multiplayer.relay"));
        relay.setSubtitle(I18n.i18n("multiplayer.relay.hint"));
        HBox pane2 = new HBox();
        pane2.setAlignment(Pos.CENTER_LEFT);
        JFXHyperlink aboutLink = new JFXHyperlink(I18n.i18n("about"));
        aboutLink.setOnAction(e -> HMCLService.openRedirectLink("multiplayer-about"));
        HBox placeholder = new HBox();
        HBox.setHgrow((Node)placeholder, (Priority)Priority.ALWAYS);
        pane2.getChildren().setAll((Object[])new Node[]{new Label("cato 1.2.0-202112171527"), aboutLink, placeholder, FXUtils.segmentToTextFlow(I18n.i18n("multiplayer.powered_by"), Controllers::onHyperlinkAction)});
        thanksPane.getContent().addAll((Object[])new Node[]{gridPane, relay, pane2});
        content.getChildren().setAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("multiplayer.session")), roomPane2, ComponentList.createComponentListTitle(I18n.i18n("multiplayer.nat")), natDetectionPane, ComponentList.createComponentListTitle(I18n.i18n("settings")), thanksPane});
    }

    public static String getNATType(@Nullable Result<DiscoveryInfo> info) {
        if (info == null) {
            return I18n.i18n("multiplayer.nat.testing");
        }
        if (info.isError()) {
            return I18n.i18n("multiplayer.nat.failed");
        }
        if (info.get().isBlockedUDP()) {
            return I18n.i18n("multiplayer.nat.type.blocked_udp");
        }
        if (info.get().isFullCone()) {
            return I18n.i18n("multiplayer.nat.type.full_cone");
        }
        if (info.get().isOpenAccess()) {
            return I18n.i18n("multiplayer.nat.type.open_access");
        }
        if (info.get().isPortRestrictedCone()) {
            return I18n.i18n("multiplayer.nat.type.port_restricted_cone");
        }
        if (info.get().isRestrictedCone()) {
            return I18n.i18n("multiplayer.nat.type.restricted_cone");
        }
        if (info.get().isSymmetric()) {
            return I18n.i18n("multiplayer.nat.type.symmetric");
        }
        if (info.get().isSymmetricUDPFirewall()) {
            return I18n.i18n("multiplayer.nat.type.symmetric_udp_firewall");
        }
        return I18n.i18n("multiplayer.nat.type.unknown");
    }

    private class ClientItem
    extends StackPane {
        ClientItem(MultiplayerChannel.CatoClient client) {
            BorderPane pane = new BorderPane();
            pane.setPadding(new Insets(8.0));
            pane.setLeft((Node)new Label(client.getUsername()));
            JFXButton kickButton = new JFXButton();
            kickButton.setGraphic(SVG.close(Theme.blackFillBinding(), 16.0, 16.0));
            kickButton.getStyleClass().add((Object)"toggle-icon-tiny");
            kickButton.setOnAction(e -> ((MultiplayerPage)MultiplayerPageSkin.this.getSkinnable()).kickPlayer(client));
            pane.setRight((Node)kickButton);
            RipplerContainer container = new RipplerContainer((Node)pane);
            this.getChildren().setAll((Object[])new Node[]{container});
            this.getStyleClass().add((Object)"md-list-cell");
        }
    }
}

