/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.JFXTreeTableView;
import com.jfoenix.controls.RecursiveTreeItem;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.curse.CurseAddon;
import org.jackhuang.hmcl.mod.modrinth.ModrinthRemoteModRepository;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.JFXCheckBoxTreeTableCell;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.versions.ModTranslations;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.i18n.I18n;

public class ModUpdatesPage
extends BorderPane
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("mods.check_updates")));
    private final ModManager modManager;
    private final ObservableList<ModUpdateObject> objects;

    public ModUpdatesPage(ModManager modManager, List<LocalModFile.ModUpdate> updates) {
        this.modManager = modManager;
        this.getStyleClass().add((Object)"gray-background");
        JFXTreeTableColumn enabledColumn = new JFXTreeTableColumn();
        enabledColumn.setCellFactory(column -> new JFXCheckBoxTreeTableCell());
        this.setupCellValueFactory(enabledColumn, ModUpdateObject::enabledProperty);
        enabledColumn.setEditable(true);
        enabledColumn.setMaxWidth(40.0);
        enabledColumn.setMinWidth(40.0);
        JFXTreeTableColumn fileNameColumn = new JFXTreeTableColumn(I18n.i18n("mods.check_updates.file"));
        this.setupCellValueFactory(fileNameColumn, ModUpdateObject::fileNameProperty);
        JFXTreeTableColumn currentVersionColumn = new JFXTreeTableColumn(I18n.i18n("mods.check_updates.current_version"));
        this.setupCellValueFactory(currentVersionColumn, ModUpdateObject::currentVersionProperty);
        JFXTreeTableColumn targetVersionColumn = new JFXTreeTableColumn(I18n.i18n("mods.check_updates.target_version"));
        this.setupCellValueFactory(targetVersionColumn, ModUpdateObject::targetVersionProperty);
        JFXTreeTableColumn sourceColumn = new JFXTreeTableColumn(I18n.i18n("mods.check_updates.source"));
        this.setupCellValueFactory(sourceColumn, ModUpdateObject::sourceProperty);
        this.objects = FXCollections.observableList(updates.stream().map(ModUpdateObject::new).collect(Collectors.toList()));
        RecursiveTreeItem<ModUpdateObject> root = new RecursiveTreeItem<ModUpdateObject>(this.objects, RecursiveTreeObject::getChildren);
        JFXTreeTableView<ModUpdateObject> table = new JFXTreeTableView<ModUpdateObject>(root);
        table.setShowRoot(false);
        table.setEditable(true);
        table.getColumns().setAll((Object[])new TreeTableColumn[]{enabledColumn, fileNameColumn, currentVersionColumn, targetVersionColumn, sourceColumn});
        this.setCenter((Node)table);
        HBox actions = new HBox(8.0);
        actions.setPadding(new Insets(8.0));
        actions.setAlignment(Pos.CENTER_RIGHT);
        JFXButton nextButton = new JFXButton(I18n.i18n("mods.check_updates.update"));
        nextButton.getStyleClass().add((Object)"jfx-button-raised");
        nextButton.setButtonType(JFXButton.ButtonType.RAISED);
        nextButton.setOnAction(e -> this.updateMods());
        JFXButton cancelButton = new JFXButton(I18n.i18n("button.cancel"));
        cancelButton.getStyleClass().add((Object)"jfx-button-raised");
        cancelButton.setButtonType(JFXButton.ButtonType.RAISED);
        cancelButton.setOnAction(e -> this.fireEvent(new PageCloseEvent()));
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
        actions.getChildren().setAll((Object[])new Node[]{nextButton, cancelButton});
        this.setBottom((Node)actions);
    }

    private <T> void setupCellValueFactory(JFXTreeTableColumn<ModUpdateObject, T> column, Function<ModUpdateObject, ObservableValue<T>> mapper) {
        column.setCellValueFactory(param -> {
            if (column.validateValue((TreeTableColumn.CellDataFeatures)param)) {
                return (ObservableValue)mapper.apply((ModUpdateObject)param.getValue().getValue());
            }
            return column.getComputedValue((TreeTableColumn.CellDataFeatures)param);
        });
    }

    private void updateMods() {
        ModUpdateTask task = new ModUpdateTask(this.modManager, this.objects.stream().filter(o -> o.enabled.get()).map(object -> Pair.pair(object.data.getLocalMod(), object.data.getCandidates().get(0))).collect(Collectors.toList()));
        Controllers.taskDialog(task.whenComplete(Schedulers.javafx(), exception -> {
            this.fireEvent(new PageCloseEvent());
            if (!task.getFailedMods().isEmpty()) {
                Controllers.dialog(I18n.i18n("mods.check_updates.failed") + "\n" + task.getFailedMods().stream().map(LocalModFile::getFileName).collect(Collectors.joining("\n")), I18n.i18n("install.failed"), MessageDialogPane.MessageType.ERROR);
            }
            if (exception == null) {
                Controllers.dialog(I18n.i18n("install.success"));
            }
        }), I18n.i18n("mods.check_updates.update"), t -> {});
    }

    public ReadOnlyObjectWrapper<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public static class ModUpdateCell
    extends MDListCell<LocalModFile.ModUpdate> {
        TwoLineListItem content = new TwoLineListItem();

        public ModUpdateCell(JFXListView<LocalModFile.ModUpdate> listView) {
            super(listView);
            this.getContainer().getChildren().setAll((Object[])new Node[]{this.content});
        }

        @Override
        protected void updateControl(LocalModFile.ModUpdate item, boolean empty) {
            if (empty) {
                return;
            }
            ModTranslations.Mod mod = ModTranslations.getModById(item.getLocalMod().getId());
            this.content.setTitle(mod != null ? mod.getDisplayName() : item.getCurrentVersion().getName());
            this.content.setSubtitle(item.getLocalMod().getFileName());
            this.content.getTags().setAll((Object[])new String[0]);
            if (item.getCurrentVersion().getSelf() instanceof CurseAddon.LatestFile) {
                this.content.getTags().add((Object)"Curseforge");
            } else if (item.getCurrentVersion().getSelf() instanceof ModrinthRemoteModRepository.ModVersion) {
                this.content.getTags().add((Object)"Modrinth");
            }
        }
    }

    private static class ModUpdateObject
    extends RecursiveTreeObject<ModUpdateObject> {
        final LocalModFile.ModUpdate data;
        final BooleanProperty enabled = new SimpleBooleanProperty();
        final StringProperty fileName = new SimpleStringProperty();
        final StringProperty currentVersion = new SimpleStringProperty();
        final StringProperty targetVersion = new SimpleStringProperty();
        final StringProperty source = new SimpleStringProperty();

        public ModUpdateObject(LocalModFile.ModUpdate data) {
            this.data = data;
            this.enabled.set(true);
            this.fileName.set((Object)data.getLocalMod().getFileName());
            this.currentVersion.set((Object)data.getCurrentVersion().getVersion());
            this.targetVersion.set((Object)data.getCandidates().get(0).getVersion());
            switch (data.getCurrentVersion().getSelf().getType()) {
                case CURSEFORGE: {
                    this.source.set((Object)I18n.i18n("mods.curseforge"));
                    break;
                }
                case MODRINTH: {
                    this.source.set((Object)I18n.i18n("mods.modrinth"));
                }
            }
        }

        public boolean isEnabled() {
            return this.enabled.get();
        }

        public BooleanProperty enabledProperty() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled.set(enabled);
        }

        public String getFileName() {
            return (String)this.fileName.get();
        }

        public StringProperty fileNameProperty() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName.set((Object)fileName);
        }

        public String getCurrentVersion() {
            return (String)this.currentVersion.get();
        }

        public StringProperty currentVersionProperty() {
            return this.currentVersion;
        }

        public void setCurrentVersion(String currentVersion) {
            this.currentVersion.set((Object)currentVersion);
        }

        public String getTargetVersion() {
            return (String)this.targetVersion.get();
        }

        public StringProperty targetVersionProperty() {
            return this.targetVersion;
        }

        public void setTargetVersion(String targetVersion) {
            this.targetVersion.set((Object)targetVersion);
        }

        public String getSource() {
            return (String)this.source.get();
        }

        public StringProperty sourceProperty() {
            return this.source;
        }

        public void setSource(String source) {
            this.source.set((Object)source);
        }
    }

    public static class ModUpdateTask
    extends Task<Void> {
        private final Collection<Task<?>> dependents;
        private final List<LocalModFile> failedMods = new ArrayList<LocalModFile>();

        ModUpdateTask(ModManager modManager, List<Pair<LocalModFile, RemoteMod.Version>> mods) {
            this.setStage("mods.check_updates.update");
            this.getProperties().put("total", mods.size());
            this.dependents = mods.stream().map(mod -> Task.runAsync(Schedulers.javafx(), () -> ((LocalModFile)mod.getKey()).setOld(true)).thenComposeAsync(() -> {
                FileDownloadTask task = new FileDownloadTask(new URL(((RemoteMod.Version)mod.getValue()).getFile().getUrl()), modManager.getModsDirectory().resolve(((RemoteMod.Version)mod.getValue()).getFile().getFilename()).toFile());
                task.setName(((RemoteMod.Version)mod.getValue()).getName());
                return task;
            }).whenComplete(Schedulers.javafx(), (Exception exception) -> {
                if (exception != null) {
                    ((LocalModFile)mod.getKey()).setOld(false);
                    this.failedMods.add((LocalModFile)mod.getKey());
                }
            }).withCounter("mods.check_updates.update")).collect(Collectors.toList());
        }

        public List<LocalModFile> getFailedMods() {
            return this.failedMods;
        }

        @Override
        public Collection<Task<?>> getDependents() {
            return this.dependents;
        }

        @Override
        public boolean doPreExecute() {
            return true;
        }

        @Override
        public void preExecute() {
            this.notifyPropertiesChanged();
        }

        @Override
        public boolean isRelyingOnDependents() {
            return false;
        }

        @Override
        public void execute() throws Exception {
        }
    }
}

