/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.io.JarUtils;

public final class IntegrityChecker {
    private static final String SIGNATURE_FILE = "META-INF/hmcl_signature";
    private static final String PUBLIC_KEY_FILE = "assets/hmcl_signature_publickey.der";
    private static Boolean selfVerified = null;

    private IntegrityChecker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PublicKey getPublicKey() throws IOException {
        try (InputStream in = IntegrityChecker.class.getResourceAsStream("/assets/hmcl_signature_publickey.der");){
            if (in == null) {
                throw new IOException("Public key not found");
            }
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(IOUtils.readFullyAsByteArray(in)));
            return publicKey;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to load public key", e);
        }
    }

    private static boolean verifyJar(Path jarPath) throws IOException {
        PublicKey publickey = IntegrityChecker.getPublicKey();
        byte[] signature = null;
        TreeMap<String, byte[]> fileFingerprints = new TreeMap<String, byte[]>();
        ZipFile zip = new ZipFile(jarPath.toFile());
        Object object = null;
        try {
            for (ZipEntry entry : (ZipEntry[])zip.stream().toArray(ZipEntry[]::new)) {
                String filename = entry.getName();
                try (InputStream in = zip.getInputStream(entry);){
                    if (in == null) {
                        throw new IOException("entry is null");
                    }
                    if (SIGNATURE_FILE.equals(filename)) {
                        signature = IOUtils.readFullyAsByteArray(in);
                        continue;
                    }
                    fileFingerprints.put(filename, DigestUtils.digest("SHA-512", in));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (zip != null) {
                if (object != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    zip.close();
                }
            }
        }
        if (signature == null) {
            throw new IOException("Signature is missing");
        }
        try {
            Signature verifier = Signature.getInstance("SHA512withRSA");
            verifier.initVerify(publickey);
            for (Map.Entry entry : fileFingerprints.entrySet()) {
                verifier.update(DigestUtils.digest("SHA-512", ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8)));
                verifier.update((byte[])entry.getValue());
            }
            return verifier.verify(signature);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to verify signature", e);
        }
    }

    static void requireVerifiedJar(Path jar) throws IOException {
        if (!IntegrityChecker.verifyJar(jar)) {
            throw new IOException("Invalid signature: " + jar);
        }
    }

    public static synchronized boolean isSelfVerified() {
        if (selfVerified != null) {
            return selfVerified;
        }
        try {
            IntegrityChecker.verifySelf();
            Logging.LOG.info("Successfully verified current JAR");
            selfVerified = true;
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Failed to verify myself, is the JAR corrupt?", e);
            selfVerified = false;
        }
        return selfVerified;
    }

    private static void verifySelf() throws IOException {
        Path self = JarUtils.thisJar().orElseThrow(() -> new IOException("Failed to find current HMCL location"));
        IntegrityChecker.requireVerifiedJar(self);
    }
}

