/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class SimpleMultimap<K, V> {
    private final Map<K, Collection<V>> map;
    private final Supplier<Collection<V>> valuer;

    public SimpleMultimap(Supplier<Map<K, Collection<V>>> mapper, Supplier<Collection<V>> valuer) {
        this.map = mapper.get();
        this.valuer = valuer;
    }

    public int size() {
        return this.values().size();
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        Collection<V> res = this.valuer.get();
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            res.addAll(entry.getValue());
        }
        return res;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key) && !this.map.get(key).isEmpty();
    }

    public Collection<V> get(K key) {
        return this.map.computeIfAbsent(key, any -> this.valuer.get());
    }

    public void put(K key, V value) {
        Collection<V> set = this.get(key);
        set.add(value);
    }

    public void putAll(K key, Collection<? extends V> value) {
        Collection<V> set = this.get(key);
        set.addAll(value);
    }

    public Collection<V> removeKey(K key) {
        return this.map.remove(key);
    }

    public boolean removeValue(V value) {
        boolean flag = false;
        for (Collection<V> c : this.map.values()) {
            flag |= c.remove(value);
        }
        return flag;
    }

    public boolean removeValue(K key, V value) {
        return this.get(key).remove(value);
    }

    public void clear() {
        this.map.clear();
    }

    public void clear(K key) {
        if (this.map.containsKey(key)) {
            this.map.get(key).clear();
        } else {
            this.map.put(key, this.valuer.get());
        }
    }
}

