/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.util.Lang;

public abstract class BindingMapping<T, U>
extends ObjectBinding<U> {
    protected final ObservableValue<T> predecessor;

    public static <T> BindingMapping<?, T> of(ObservableValue<T> property) {
        if (property instanceof BindingMapping) {
            return (BindingMapping)property;
        }
        return new SimpleBinding<T>(property);
    }

    public static <S extends Observable, T> BindingMapping<?, T> of(S watched, Function<S, T> mapper) {
        return BindingMapping.of(Bindings.createObjectBinding(() -> mapper.apply(watched), (Observable[])new Observable[]{watched}));
    }

    public BindingMapping(ObservableValue<T> predecessor) {
        this.predecessor = Objects.requireNonNull(predecessor);
        this.bind(new Observable[]{predecessor});
    }

    public <V> BindingMapping<?, V> map(Function<U, V> mapper) {
        return new MappedBinding<U, V>(this, mapper);
    }

    public <V> BindingMapping<?, V> flatMap(Function<U, ? extends ObservableValue<V>> mapper) {
        return this.flatMap(mapper, null);
    }

    public <V> BindingMapping<?, V> flatMap(Function<U, ? extends ObservableValue<V>> mapper, Supplier<V> nullAlternative) {
        return new FlatMappedBinding(this.map(mapper), nullAlternative);
    }

    public <V> BindingMapping<?, V> asyncMap(Function<U, CompletableFuture<V>> mapper, V initial) {
        return new AsyncMappedBinding<U, V>(this, mapper, initial);
    }

    private static class AsyncMappedBinding<T, U>
    extends BindingMapping<T, U> {
        private boolean initialized = false;
        private T prev;
        private U value;
        private final Function<T, CompletableFuture<U>> mapper;
        private T computingPrev;
        private boolean computing = false;

        public AsyncMappedBinding(ObservableValue<T> predecessor, Function<T, CompletableFuture<U>> mapper, U initial) {
            super(predecessor);
            this.value = initial;
            this.mapper = mapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryUpdateValue(T currentPrev) {
            CompletableFuture<U> task;
            AsyncMappedBinding asyncMappedBinding = this;
            synchronized (asyncMappedBinding) {
                if (this.initialized && Objects.equals(this.prev, currentPrev) || this.isComputing(currentPrev)) {
                    return;
                }
                this.computing = true;
                this.computingPrev = currentPrev;
            }
            try {
                task = Objects.requireNonNull(this.mapper.apply(currentPrev));
            }
            catch (Throwable e2) {
                this.valueUpdateFailed(currentPrev);
                throw e2;
            }
            task.handle((result, e) -> {
                if (e == null) {
                    this.valueUpdate(currentPrev, result);
                    Platform.runLater(() -> ((AsyncMappedBinding)this).invalidate());
                } else {
                    Lang.handleUncaughtException(e);
                    this.valueUpdateFailed(currentPrev);
                }
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void valueUpdate(T currentPrev, U computed) {
            AsyncMappedBinding asyncMappedBinding = this;
            synchronized (asyncMappedBinding) {
                if (this.isComputing(currentPrev)) {
                    this.computing = false;
                    this.computingPrev = null;
                    this.prev = currentPrev;
                    this.value = computed;
                    this.initialized = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void valueUpdateFailed(T currentPrev) {
            AsyncMappedBinding asyncMappedBinding = this;
            synchronized (asyncMappedBinding) {
                if (this.isComputing(currentPrev)) {
                    this.computing = false;
                    this.computingPrev = null;
                }
            }
        }

        private boolean isComputing(T prev) {
            return this.computing && Objects.equals(prev, this.computingPrev);
        }

        protected U computeValue() {
            this.tryUpdateValue(this.predecessor.getValue());
            return this.value;
        }
    }

    private static class FlatMappedBinding<T extends ObservableValue<U>, U>
    extends BindingMapping<T, U> {
        private final Supplier<U> nullAlternative;
        private T lastObservable = null;

        public FlatMappedBinding(ObservableValue<T> predecessor, Supplier<U> nullAlternative) {
            super(predecessor);
            this.nullAlternative = nullAlternative;
        }

        protected U computeValue() {
            ObservableValue currentObservable = (ObservableValue)this.predecessor.getValue();
            if (currentObservable != this.lastObservable) {
                if (this.lastObservable != null) {
                    this.unbind(new Observable[]{this.lastObservable});
                }
                if (currentObservable != null) {
                    this.bind(new Observable[]{currentObservable});
                }
                this.lastObservable = currentObservable;
            }
            if (currentObservable == null) {
                if (this.nullAlternative == null) {
                    throw new NullPointerException();
                }
                return this.nullAlternative.get();
            }
            return (U)currentObservable.getValue();
        }
    }

    private static class MappedBinding<T, U>
    extends BindingMapping<T, U> {
        private final Function<T, U> mapper;

        public MappedBinding(ObservableValue<T> predecessor, Function<T, U> mapper) {
            super(predecessor);
            this.mapper = mapper;
        }

        protected U computeValue() {
            return this.mapper.apply(this.predecessor.getValue());
        }
    }

    private static class SimpleBinding<T>
    extends BindingMapping<T, T> {
        public SimpleBinding(ObservableValue<T> predecessor) {
            super(predecessor);
        }

        protected T computeValue() {
            return (T)this.predecessor.getValue();
        }

        @Override
        public <V> BindingMapping<?, V> map(Function<T, V> mapper) {
            return new MappedBinding<T, V>(this.predecessor, mapper);
        }

        @Override
        public <V> BindingMapping<?, V> asyncMap(Function<T, CompletableFuture<V>> mapper, V initial) {
            return new AsyncMappedBinding<T, V>(this.predecessor, mapper, initial);
        }
    }
}

