/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.javafx;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import org.jackhuang.hmcl.util.function.ExceptionalFunction;
import org.jackhuang.hmcl.util.javafx.ObservableHelper;

public class ObservableCache<K, V, E extends Exception> {
    private final ExceptionalFunction<K, V, E> source;
    private final BiConsumer<K, Throwable> exceptionHandler;
    private final V fallbackValue;
    private final Executor executor;
    private final ObservableHelper observable = new ObservableHelper();
    private final Map<K, V> cache = new HashMap();
    private final Map<K, CompletableFuture<V>> pendings = new HashMap<K, CompletableFuture<V>>();
    private final Map<K, Boolean> invalidated = new HashMap<K, Boolean>();

    public ObservableCache(ExceptionalFunction<K, V, E> source, BiConsumer<K, Throwable> exceptionHandler, V fallbackValue, Executor executor) {
        this.source = source;
        this.exceptionHandler = exceptionHandler;
        this.fallbackValue = fallbackValue;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> getImmediately(K key) {
        ObservableCache observableCache = this;
        synchronized (observableCache) {
            return Optional.ofNullable(this.cache.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        ObservableCache observableCache = this;
        synchronized (observableCache) {
            this.cache.put(key, value);
            this.invalidated.remove(key);
        }
        Platform.runLater(this.observable::invalidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<V> query(K key, Executor executor) {
        CompletableFuture future;
        ObservableCache observableCache = this;
        synchronized (observableCache) {
            CompletableFuture<V> prev = this.pendings.get(key);
            if (prev != null) {
                return prev;
            }
            future = new CompletableFuture();
            this.pendings.put(key, future);
        }
        executor.execute(() -> {
            V result;
            try {
                result = this.source.apply(key);
            }
            catch (Throwable ex) {
                ObservableCache observableCache = this;
                synchronized (observableCache) {
                    this.pendings.remove(key);
                }
                this.exceptionHandler.accept(key, ex);
                future.completeExceptionally(ex);
                return;
            }
            ObservableCache observableCache = this;
            synchronized (observableCache) {
                this.cache.put(key, result);
                this.invalidated.remove(key);
                this.pendings.remove(key, future);
            }
            future.complete(result);
            Platform.runLater(this.observable::invalidate);
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V cached;
        ObservableCache observableCache = this;
        synchronized (observableCache) {
            cached = this.cache.get(key);
            if (cached != null && !this.invalidated.containsKey(key)) {
                return cached;
            }
        }
        try {
            return this.query(key, Runnable::run).join();
        }
        catch (CancellationException | CompletionException runtimeException) {
            if (cached == null) {
                return this.fallbackValue;
            }
            return cached;
        }
    }

    public V getDirectly(K key) throws E {
        V result = this.source.apply(key);
        this.put(key, result);
        return result;
    }

    public ObjectBinding<V> binding(K key) {
        return this.binding(key, false);
    }

    public ObjectBinding<V> binding(K key, boolean quiet) {
        return Bindings.createObjectBinding(() -> {
            boolean refresh;
            V result;
            ObservableCache observableCache = this;
            synchronized (observableCache) {
                result = this.cache.get(key);
                if (result == null) {
                    result = this.fallbackValue;
                    refresh = true;
                } else {
                    refresh = this.invalidated.containsKey(key);
                }
            }
            if (!quiet && refresh) {
                this.query(key, this.executor);
            }
            return result;
        }, (Observable[])new Observable[]{this.observable});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(K key) {
        ObservableCache observableCache = this;
        synchronized (observableCache) {
            if (this.cache.containsKey(key)) {
                this.invalidated.put(key, Boolean.TRUE);
            }
        }
        Platform.runLater(this.observable::invalidate);
    }
}

