/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class Architecture
extends Enum<Architecture> {
    public static final /* enum */ Architecture X86;
    public static final /* enum */ Architecture X86_64;
    public static final /* enum */ Architecture IA32;
    public static final /* enum */ Architecture IA64;
    public static final /* enum */ Architecture SPARC;
    public static final /* enum */ Architecture SPARCV9;
    public static final /* enum */ Architecture ARM32;
    public static final /* enum */ Architecture ARM64;
    public static final /* enum */ Architecture MIPS;
    public static final /* enum */ Architecture MIPS64;
    public static final /* enum */ Architecture MIPSEL;
    public static final /* enum */ Architecture MIPS64EL;
    public static final /* enum */ Architecture PPC;
    public static final /* enum */ Architecture PPC64;
    public static final /* enum */ Architecture PPCLE;
    public static final /* enum */ Architecture PPC64LE;
    public static final /* enum */ Architecture S390;
    public static final /* enum */ Architecture S390X;
    public static final /* enum */ Architecture RISCV;
    public static final /* enum */ Architecture UNKNOWN;
    private final String checkedName;
    private final String displayName;
    private final Bits bits;
    public static final String CURRENT_ARCH_NAME;
    public static final String SYSTEM_ARCH_NAME;
    public static final Architecture CURRENT_ARCH;
    public static final Architecture SYSTEM_ARCH;
    private static final /* synthetic */ Architecture[] $VALUES;

    public static Architecture[] values() {
        return (Architecture[])$VALUES.clone();
    }

    public static Architecture valueOf(String name) {
        return Enum.valueOf(Architecture.class, name);
    }

    private Architecture(Bits bits) {
        this.checkedName = this.toString().toLowerCase(Locale.ROOT);
        this.displayName = this.toString();
        this.bits = bits;
    }

    private Architecture(Bits bits, String displayName) {
        this.checkedName = this.toString().toLowerCase(Locale.ROOT);
        this.displayName = displayName;
        this.bits = bits;
    }

    private Architecture(Bits bits, String displayName, String identifier) {
        this.checkedName = identifier;
        this.displayName = displayName;
        this.bits = bits;
    }

    public Bits getBits() {
        return this.bits;
    }

    public String getCheckedName() {
        return this.checkedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isX86() {
        return this == X86 || this == X86_64;
    }

    public static Architecture parseArchName(String value) {
        if (value == null) {
            return UNKNOWN;
        }
        switch (value = value.trim().toLowerCase(Locale.ROOT)) {
            case "x8664": 
            case "x86-64": 
            case "x86_64": 
            case "amd64": 
            case "ia32e": 
            case "em64t": 
            case "x64": {
                return X86_64;
            }
            case "x8632": 
            case "x86-32": 
            case "x86_32": 
            case "x86": 
            case "i86pc": 
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": 
            case "ia32": 
            case "x32": {
                return X86;
            }
            case "arm64": 
            case "aarch64": {
                return ARM64;
            }
            case "arm": 
            case "arm32": {
                return ARM32;
            }
            case "mips64": {
                return MIPS64;
            }
            case "mips64el": {
                return MIPS64EL;
            }
            case "mips": 
            case "mips32": {
                return MIPS;
            }
            case "mipsel": 
            case "mips32el": {
                return MIPSEL;
            }
            case "riscv": 
            case "risc-v": {
                return RISCV;
            }
            case "ia64": 
            case "ia64w": 
            case "itanium64": {
                return IA64;
            }
            case "ia64n": {
                return IA32;
            }
            case "sparcv9": 
            case "sparc64": {
                return SPARCV9;
            }
            case "sparc": 
            case "sparc32": {
                return SPARC;
            }
            case "ppc64": 
            case "powerpc64": {
                return "little".equals(System.getProperty("sun.cpu.endian")) ? PPC64LE : PPC64;
            }
            case "ppc64le": 
            case "powerpc64le": {
                return PPC64LE;
            }
            case "ppc": 
            case "ppc32": 
            case "powerpc": 
            case "powerpc32": {
                return PPC;
            }
            case "ppcle": 
            case "ppc32le": 
            case "powerpcle": 
            case "powerpc32le": {
                return PPCLE;
            }
            case "s390": {
                return S390;
            }
            case "s390x": {
                return S390X;
            }
        }
        if (value.startsWith("armv7")) {
            return ARM32;
        }
        if (value.startsWith("armv8") || value.startsWith("armv9")) {
            return ARM64;
        }
        return UNKNOWN;
    }

    static {
        String sysArchName;
        block21: {
            X86 = new Architecture(Bits.BIT_32, "x86");
            X86_64 = new Architecture(Bits.BIT_64, "x86-64");
            IA32 = new Architecture(Bits.BIT_32, "IA-32");
            IA64 = new Architecture(Bits.BIT_64, "IA-64");
            SPARC = new Architecture(Bits.BIT_32);
            SPARCV9 = new Architecture(Bits.BIT_64, "SPARC V9");
            ARM32 = new Architecture(Bits.BIT_32);
            ARM64 = new Architecture(Bits.BIT_64);
            MIPS = new Architecture(Bits.BIT_32);
            MIPS64 = new Architecture(Bits.BIT_64);
            MIPSEL = new Architecture(Bits.BIT_32, "MIPSel");
            MIPS64EL = new Architecture(Bits.BIT_64, "MIPS64el");
            PPC = new Architecture(Bits.BIT_32, "PowerPC");
            PPC64 = new Architecture(Bits.BIT_64, "PowerPC-64");
            PPCLE = new Architecture(Bits.BIT_32, "PowerPC (Little-Endian)");
            PPC64LE = new Architecture(Bits.BIT_64, "PowerPC-64 (Little-Endian)");
            S390 = new Architecture(Bits.BIT_32);
            S390X = new Architecture(Bits.BIT_64, "S390x");
            RISCV = new Architecture(Bits.BIT_64, "RISC-V");
            UNKNOWN = new Architecture(Bits.UNKNOWN, "Unknown");
            $VALUES = new Architecture[]{X86, X86_64, IA32, IA64, SPARC, SPARCV9, ARM32, ARM64, MIPS, MIPS64, MIPSEL, MIPS64EL, PPC, PPC64, PPCLE, PPC64LE, S390, S390X, RISCV, UNKNOWN};
            CURRENT_ARCH_NAME = System.getProperty("os.arch");
            CURRENT_ARCH = Architecture.parseArchName(CURRENT_ARCH_NAME);
            sysArchName = null;
            if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
                int idx;
                String processorIdentifier = System.getenv("PROCESSOR_IDENTIFIER");
                if (processorIdentifier != null && (idx = processorIdentifier.indexOf(32)) > 0) {
                    sysArchName = processorIdentifier.substring(0, idx);
                }
            } else {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"/bin/uname", "-m"});
                    if (!process.waitFor(3L, TimeUnit.SECONDS)) break block21;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), OperatingSystem.NATIVE_CHARSET));){
                        sysArchName = reader.readLine().trim();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable process) {
                    // empty catch block
                }
            }
        }
        Architecture sysArch = Architecture.parseArchName(sysArchName);
        if (sysArch == UNKNOWN) {
            SYSTEM_ARCH_NAME = CURRENT_ARCH_NAME;
            SYSTEM_ARCH = CURRENT_ARCH;
        } else {
            SYSTEM_ARCH_NAME = sysArchName;
            SYSTEM_ARCH = sysArch;
        }
    }
}

