/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ManagedProcess {
    private final Process process;
    private final List<String> commands;
    private final String classpath;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Queue<String> lines = new ConcurrentLinkedQueue<String>();
    private final List<Thread> relatedThreads = new ArrayList<Thread>();

    public ManagedProcess(Process process, List<String> commands) {
        this.process = process;
        this.commands = Collections.unmodifiableList(new ArrayList<String>(commands));
        this.classpath = null;
    }

    public ManagedProcess(Process process, List<String> commands, String classpath) {
        this.process = process;
        this.commands = Collections.unmodifiableList(new ArrayList<String>(commands));
        this.classpath = classpath;
    }

    public Process getProcess() {
        return this.process;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Collection<String> getLines() {
        return Collections.unmodifiableCollection(this.lines);
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public synchronized void addRelatedThread(Thread thread) {
        this.relatedThreads.add(thread);
    }

    public boolean isRunning() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public int getExitCode() {
        return this.process.exitValue();
    }

    public void stop() {
        this.process.destroy();
        this.destroyRelatedThreads();
    }

    public synchronized void destroyRelatedThreads() {
        this.relatedThreads.forEach(Thread::interrupt);
    }

    public String toString() {
        return "ManagedProcess[commands=" + this.commands + ", isRunning=" + this.isRunning() + "]";
    }
}

