/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class MapReduceNature
implements IProjectNature {
    public static final String ID = "org.apache.hadoop.eclipse.Nature";
    private IProject project;
    static Logger log = Logger.getLogger(MapReduceNature.class.getName());

    public void configure() throws CoreException {
        String path = this.project.getPersistentProperty(new QualifiedName("org.apache.hadoop.eclipse", "hadoop.runtime.path"));
        path = path + File.separatorChar + "share" + File.separatorChar + "hadoop";
        String[] dirs = new String[]{"common", "mapreduce", "hdfs", "yarn"};
        ArrayList coreJars = new ArrayList();
        for (String sub : dirs) {
            File dir = new File(path + File.separatorChar + sub);
            dir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
            File dir2 = new File(path + File.separatorChar + sub + File.separatorChar + "lib");
            if (!dir2.exists() || !dir2.isDirectory()) continue;
            dir2.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        try {
            IClasspathEntry[] currentCp = javaProject.getRawClasspath();
            IClasspathEntry[] newCp = new IClasspathEntry[currentCp.length + coreJars.size()];
            System.arraycopy(currentCp, 0, newCp, 0, currentCp.length);
            Iterator i = coreJars.iterator();
            int count = 0;
            while (i.hasNext()) {
                File f = (File)i.next();
                URL url = f.toURI().toURL();
                log.finer("hadoop library url.getPath() = " + url.getPath());
                newCp[newCp.length - 1 - count] = JavaCore.newLibraryEntry((IPath)new Path(url.getPath()), null, null);
                ++count;
            }
            javaProject.setRawClasspath(newCp, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "IOException generated in " + this.getClass().getCanonicalName(), e);
        }
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

