/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse;

import java.util.ArrayList;
import org.apache.hadoop.eclipse.ImageLibrary;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewDriverWizardPage
extends NewTypeWizardPage {
    private Button isCreateMapMethod;
    private Text reducerText;
    private Text mapperText;
    private final boolean showContainerSelector;

    public NewDriverWizardPage() {
        this(true);
    }

    public NewDriverWizardPage(boolean showContainerSelector) {
        super(true, "MapReduce Driver");
        this.showContainerSelector = showContainerSelector;
        this.setTitle("MapReduce Driver");
        this.setDescription("Create a new MapReduce driver.");
        this.setImageDescriptor(ImageLibrary.get((String)"wizard.driver.new"));
    }

    public void setSelection(IStructuredSelection selection) {
        this.initContainerPage(this.getInitialJavaElement(selection));
        this.initTypePage(this.getInitialJavaElement(selection));
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        super.createType(monitor);
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        super.createTypeMembers(newType, imports, monitor);
        imports.addImport("org.apache.hadoop.fs.Path");
        imports.addImport("org.apache.hadoop.io.Text");
        imports.addImport("org.apache.hadoop.conf.Configuration");
        imports.addImport("org.apache.hadoop.mapreduce.Job");
        imports.addImport("org.apache.hadoop.mapreduce.Reducer");
        imports.addImport("org.apache.hadoop.mapreduce.Mapper");
        imports.addImport("org.apache.hadoop.mapreduce.lib.input.FileInputFormat");
        imports.addImport("org.apache.hadoop.mapreduce.lib.output.FileOutputFormat");
        this.getContainer().getShell().getDisplay().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, 4);
        this.createPackageControls(composite, 4);
        this.createSeparator(composite, 4);
        this.createTypeNameControls(composite, 4);
        this.createSuperClassControls(composite, 4);
        this.createSuperInterfacesControls(composite, 4);
        this.createSeparator(composite, 4);
        this.createMapperControls(composite);
        this.createReducerControls(composite);
        if (!this.showContainerSelector) {
            this.setPackageFragmentRoot(null, false);
            this.setSuperClass("java.lang.Object", false);
            this.setSuperInterfaces(new ArrayList(), false);
        }
        this.setControl((Control)composite);
        this.setFocus();
        this.handleFieldChanged("NewContainerWizardPage.container");
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.validate();
    }

    private void validate() {
        if (this.showContainerSelector) {
            this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus});
        } else {
            this.updateStatus(new IStatus[]{this.fTypeNameStatus});
        }
    }

    private void createMapperControls(Composite composite) {
        this.mapperText = this.createBrowseClassControl(composite, "Ma&pper:", "&Browse...", "org.apache.hadoop.mapreduce.Mapper", "Mapper Selection");
    }

    private void createReducerControls(Composite composite) {
        this.reducerText = this.createBrowseClassControl(composite, "&Reducer:", "Browse&...", "org.apache.hadoop.mapreduce.Reducer", "Reducer Selection");
    }

    private Text createBrowseClassControl(Composite composite, String string, String browseButtonLabel, String baseClassName, String dialogTitle) {
        Label label = new Label(composite, 0);
        GridData data = new GridData(768);
        label.setText(string);
        label.setLayoutData((Object)data);
        Text text = new Text(composite, 2052);
        GridData data2 = new GridData(768);
        data2.horizontalSpan = 2;
        text.setLayoutData((Object)data2);
        Button browse = new Button(composite, 0);
        browse.setText(browseButtonLabel);
        GridData data3 = new GridData(768);
        browse.setLayoutData((Object)data3);
        browse.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.showContainerSelector) {
            label.setEnabled(false);
            text.setEnabled(false);
            browse.setEnabled(false);
        }
        return text;
    }

    static /* synthetic */ Text access$000(NewDriverWizardPage x0) {
        return x0.mapperText;
    }

    static /* synthetic */ Text access$100(NewDriverWizardPage x0) {
        return x0.reducerText;
    }
}

