/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.eclipse.actions.DFSFileEditorInput;
import org.apache.hadoop.eclipse.dfs.DFSFile;
import org.apache.hadoop.eclipse.dfs.DFSFolder;
import org.apache.hadoop.eclipse.dfs.DFSLocation;
import org.apache.hadoop.eclipse.dfs.DFSLocationsRoot;
import org.apache.hadoop.eclipse.dfs.DFSPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * Exception performing whole class analysis ignored.
 */
public class DFSActionImpl
implements IObjectActionDelegate {
    private ISelection selection;
    private IWorkbenchPart targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)this.selection;
        String actionId = action.getActionDefinitionId();
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void mkdir(IStructuredSelection selection) {
        List folders = DFSActionImpl.filterSelection(DFSFolder.class, (IStructuredSelection)selection);
        if (folders.size() >= 1) {
            DFSFolder folder = (DFSFolder)folders.get(0);
            InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Create subfolder", "Enter the name of the subfolder", "", null);
            if (dialog.open() == 0) {
                folder.mkdir(dialog.getValue());
            }
        }
    }

    private void uploadFilesToDFS(IStructuredSelection selection) throws InvocationTargetException, InterruptedException {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4098);
        dialog.setText("Select the local files to upload");
        dialog.open();
        ArrayList<File> files = new ArrayList<File>();
        for (String fname : dialog.getFileNames()) {
            files.add(new File(dialog.getFilterPath() + File.separator + fname));
        }
        List folders = DFSActionImpl.filterSelection(DFSFolder.class, (IStructuredSelection)selection);
        if (folders.size() >= 1) {
            this.uploadToDFS((DFSFolder)folders.get(0), files);
        }
    }

    private void uploadDirectoryToDFS(IStructuredSelection selection) throws InvocationTargetException, InterruptedException {
        DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 4098);
        dialog.setText("Select the local file or directory to upload");
        String dirName = dialog.open();
        File dir = new File(dirName);
        ArrayList<File> files = new ArrayList<File>();
        files.add(dir);
        List folders = DFSActionImpl.filterSelection(DFSFolder.class, (IStructuredSelection)selection);
        if (folders.size() >= 1) {
            this.uploadToDFS((DFSFolder)folders.get(0), files);
        }
    }

    private void uploadToDFS(DFSFolder folder, List<File> files) throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void reconnect(IStructuredSelection selection) {
        for (DFSLocation location : DFSActionImpl.filterSelection(DFSLocation.class, (IStructuredSelection)selection)) {
            location.reconnect();
        }
    }

    private void disconnect(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof DFSLocationsRoot)) {
            return;
        }
        DFSLocationsRoot root = (DFSLocationsRoot)first;
        root.disconnect();
        root.refresh();
    }

    private void downloadFromDFS(IStructuredSelection selection) throws InvocationTargetException, InterruptedException {
        DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        dialog.setText("Copy to local directory");
        dialog.setMessage("Copy the selected files and directories from the distributed filesystem to a local directory");
        String directory = dialog.open();
        if (directory == null) {
            return;
        }
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            MessageDialog.openError(null, (String)"Download to local file system", (String)("Invalid directory location: \"" + dir + "\""));
            return;
        }
        List paths = DFSActionImpl.filterSelection(DFSPath.class, (IStructuredSelection)selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void open(IStructuredSelection selection) throws IOException, PartInitException, InvocationTargetException, InterruptedException {
        for (DFSFile file : DFSActionImpl.filterSelection(DFSFile.class, (IStructuredSelection)selection)) {
            DFSFileEditorInput editorInput = new DFSFileEditorInput(file);
            this.targetPart.getSite().getWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.eclipse.ui.DefaultTextEditor");
        }
    }

    private void refresh(IStructuredSelection selection) {
        for (DFSPath path : DFSActionImpl.filterSelection(DFSPath.class, (IStructuredSelection)selection)) {
            path.refresh();
        }
    }

    private void delete(IStructuredSelection selection) {
        List list = DFSActionImpl.filterSelection(DFSPath.class, (IStructuredSelection)selection);
        if (list.isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Are you sure you want to delete the following files from the distributed file system?\n");
        for (DFSPath path : list) {
            msg.append(path.getPath()).append("\n");
        }
        if (MessageDialog.openConfirm(null, (String)"Confirm Delete from DFS", (String)msg.toString())) {
            HashSet<DFSPath> toRefresh = new HashSet<DFSPath>();
            for (DFSPath path : list) {
                path.delete();
                toRefresh.add(path.getParent());
            }
            for (DFSPath path : toRefresh) {
                path.refresh();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    private static <T> List<T> filterSelection(Class<T> clazz, IStructuredSelection selection) {
        ArrayList list = new ArrayList();
        for (Object obj : selection.toList()) {
            if (!clazz.isAssignableFrom(obj.getClass())) continue;
            list.add(obj);
        }
        return list;
    }

    private static int computeUploadWork(File file) {
        if (file.isDirectory()) {
            int contentWork = 1;
            for (File child : file.listFiles()) {
                contentWork += DFSActionImpl.computeUploadWork((File)child);
            }
            return contentWork;
        }
        if (file.isFile()) {
            return 1 + (int)(file.length() / 1024L);
        }
        return 0;
    }

    static /* synthetic */ void access$000(DFSActionImpl x0, IStructuredSelection x1) {
        x0.delete(x1);
    }

    static /* synthetic */ void access$100(DFSActionImpl x0, IStructuredSelection x1) throws IOException, PartInitException, InvocationTargetException, InterruptedException {
        x0.open(x1);
    }

    static /* synthetic */ void access$200(DFSActionImpl x0, IStructuredSelection x1) {
        x0.mkdir(x1);
    }

    static /* synthetic */ void access$300(DFSActionImpl x0, IStructuredSelection x1) throws InvocationTargetException, InterruptedException {
        x0.uploadFilesToDFS(x1);
    }

    static /* synthetic */ void access$400(DFSActionImpl x0, IStructuredSelection x1) throws InvocationTargetException, InterruptedException {
        x0.uploadDirectoryToDFS(x1);
    }

    static /* synthetic */ void access$500(DFSActionImpl x0, IStructuredSelection x1) {
        x0.refresh(x1);
    }

    static /* synthetic */ void access$600(DFSActionImpl x0, IStructuredSelection x1) throws InvocationTargetException, InterruptedException {
        x0.downloadFromDFS(x1);
    }

    static /* synthetic */ void access$700(DFSActionImpl x0, IStructuredSelection x1) {
        x0.reconnect(x1);
    }

    static /* synthetic */ void access$800(DFSActionImpl x0, IStructuredSelection x1) {
        x0.disconnect(x1);
    }

    static /* synthetic */ int access$900(File x0) {
        return DFSActionImpl.computeUploadWork((File)x0);
    }
}

