/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.dfs;

import org.apache.hadoop.eclipse.dfs.ActionProvider;
import org.apache.hadoop.eclipse.dfs.DFSActions;
import org.apache.hadoop.eclipse.dfs.DFSFile;
import org.apache.hadoop.eclipse.dfs.DFSFolder;
import org.apache.hadoop.eclipse.dfs.DFSLocation;
import org.apache.hadoop.eclipse.dfs.DFSLocationsRoot;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class ActionProvider
extends CommonActionProvider {
    private static ICommonActionExtensionSite site;

    public void init(ICommonActionExtensionSite site) {
        if (ActionProvider.site != null) {
            System.err.printf("%s: Multiple init()\n", this.getClass().getCanonicalName());
            return;
        }
        super.init(site);
        ActionProvider.site = site;
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new DFSAction(DFSActions.DELETE));
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)new DFSAction(DFSActions.REFRESH));
        if (site == null) {
            return;
        }
        if (site.getStructuredViewer().getSelection() instanceof IStructuredSelection && ((IStructuredSelection)site.getStructuredViewer().getSelection()).size() == 1 && ((IStructuredSelection)site.getStructuredViewer().getSelection()).getFirstElement() instanceof DFSFile) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)new DFSAction(DFSActions.OPEN));
        }
        actionBars.updateActionBars();
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.appendToGroup("group.edit", (IAction)new DFSAction(DFSActions.DELETE));
        menu.appendToGroup("group.open", (IAction)new DFSAction(DFSActions.REFRESH));
        menu.appendToGroup("group.new", (IAction)new DFSAction(DFSActions.DOWNLOAD));
        if (site == null) {
            return;
        }
        ISelection isel = site.getStructuredViewer().getSelection();
        if (!(isel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection issel = (IStructuredSelection)isel;
        if (issel.size() != 1) {
            return;
        }
        Object element = issel.getFirstElement();
        if (element instanceof DFSFile) {
            menu.appendToGroup("group.open", (IAction)new DFSAction(DFSActions.OPEN));
        } else if (element instanceof DFSFolder) {
            menu.appendToGroup("group.new", (IAction)new DFSAction(DFSActions.MKDIR));
            menu.appendToGroup("group.new", (IAction)new DFSAction(DFSActions.UPLOAD_FILES));
            menu.appendToGroup("group.new", (IAction)new DFSAction(DFSActions.UPLOAD_DIR));
        } else if (element instanceof DFSLocation) {
            menu.appendToGroup("group.open", (IAction)new DFSAction(DFSActions.RECONNECT));
        } else if (element instanceof DFSLocationsRoot) {
            menu.appendToGroup("group.open", (IAction)new DFSAction(DFSActions.DISCONNECT));
        }
    }

    static /* synthetic */ ICommonActionExtensionSite access$000() {
        return site;
    }
}

