/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.dfs;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.eclipse.ImageLibrary;
import org.apache.hadoop.eclipse.dfs.DFSContent;
import org.apache.hadoop.eclipse.dfs.DFSFile;
import org.apache.hadoop.eclipse.dfs.DFSFolder;
import org.apache.hadoop.eclipse.dfs.DFSLocation;
import org.apache.hadoop.eclipse.dfs.DFSLocationsRoot;
import org.apache.hadoop.eclipse.dfs.DFSPath;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.eclipse.servers.ServerRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DFSContentProvider
implements ITreeContentProvider,
ILabelProvider {
    private Viewer viewer;
    private StructuredViewer sviewer;
    private Map<HadoopServer, DFSContent> rootFolders = new HashMap();
    private final DFSLocationsRoot locationsRoot = new DFSLocationsRoot(this);

    public Object[] getChildren(Object parent) {
        if (!(parent instanceof DFSContent)) {
            return null;
        }
        DFSContent content = (DFSContent)parent;
        return content.getChildren();
    }

    public Object[] test(Object parentElement) {
        if (parentElement instanceof DFSLocationsRoot) {
            return ServerRegistry.getInstance().getServers().toArray();
        }
        if (parentElement instanceof HadoopServer) {
            HadoopServer location = (HadoopServer)parentElement;
            Object root = this.rootFolders.get(location);
            if (root != null) {
                return new Object[]{root};
            }
            return new Object[]{"Connecting to DFS..."};
        }
        if (parentElement instanceof DFSFolder) {
            DFSFolder folder = (DFSFolder)parentElement;
            return folder.getChildren();
        }
        return new Object[]{"<Unknown DFSContent>"};
    }

    public Object getParent(Object element) {
        if (element instanceof DFSPath) {
            return ((DFSPath)element).getParent();
        }
        if (element instanceof HadoopServer) {
            return this.locationsRoot;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof DFSContent) {
            DFSContent content = (DFSContent)element;
            return content.hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{this.locationsRoot};
    }

    public Image getImage(Object element) {
        if (element instanceof DFSLocationsRoot) {
            return ImageLibrary.getImage((String)"dfs.browser.root.entry");
        }
        if (element instanceof DFSLocation) {
            return ImageLibrary.getImage((String)"dfs.browser.location.entry");
        }
        if (element instanceof DFSFolder) {
            return ImageLibrary.getImage((String)"dfs.browser.folder.entry");
        }
        if (element instanceof DFSFile) {
            return ImageLibrary.getImage((String)"dfs.browser.file.entry");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof DFSFile) {
            return ((DFSFile)element).toDetailedString();
        }
        return element.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.sviewer = viewer != null && viewer instanceof StructuredViewer ? (StructuredViewer)viewer : null;
    }

    void refresh() {
        if (this.viewer == null) {
            return;
        }
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    void refresh(DFSContent content) {
        if (this.sviewer != null) {
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.refresh();
        }
    }

    Viewer getViewer() {
        return this.viewer;
    }

    static /* synthetic */ Viewer access$000(DFSContentProvider x0) {
        return x0.viewer;
    }

    static /* synthetic */ StructuredViewer access$100(DFSContentProvider x0) {
        return x0.sviewer;
    }
}

