/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.eclipse.ErrorMessageDialog;
import org.apache.hadoop.eclipse.dfs.DFSContent;
import org.apache.hadoop.eclipse.dfs.DFSFile;
import org.apache.hadoop.eclipse.dfs.DFSPath;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class DFSFile
extends DFSPath
implements DFSContent {
    protected long length;
    protected short replication;

    public DFSFile(DFSPath parent, Path path, File file, IProgressMonitor monitor) {
        super(parent, path);
        this.upload(monitor, file);
    }

    public DFSFile(DFSPath parent, Path path) {
        super(parent, path);
        try {
            FileStatus fs = this.getDFS().getFileStatus(path);
            this.length = fs.getLen();
            this.replication = fs.getReplication();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputStream open() throws IOException {
        return this.getDFS().open(this.path);
    }

    public void downloadToLocalFile(File file) throws InvocationTargetException, InterruptedException {
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void downloadToLocalDirectory(IProgressMonitor monitor, File dir) {
        boolean answer;
        File dfsPath = new File(this.getPath().toString());
        File destination = new File(dir, dfsPath.getName());
        if (destination.exists() && !(answer = MessageDialog.openQuestion(null, (String)"Overwrite existing local file?", (String)("The file you are attempting to download from the DFS " + this.getPath() + ", already exists in your local directory as " + destination + ".\n" + "Overwrite the existing file?")))) {
            return;
        }
        try {
            this.downloadToLocalFile(monitor, destination);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openWarning(null, (String)"Download to local file system", (String)("Downloading of file \"" + this.path + "\" to local directory \"" + dir + "\" has failed.\n" + e));
        }
    }

    public String toDetailedString() {
        double l;
        String[] units = new String[]{"b", "Kb", "Mb", "Gb", "Tb"};
        int unit = 0;
        for (l = (double)this.length; l >= 1024.0 && unit < units.length; ++unit, l /= 1024.0) {
        }
        return String.format("%s (%.1f %s, r%d)", super.toString(), l, units[unit], this.replication);
    }

    public String toString() {
        return this.path.toString();
    }

    public void downloadToLocalFile(IProgressMonitor monitor, File file) throws InvocationTargetException {
        int taskSize = 1024;
        monitor.setTaskName("Download file " + this.path);
        FilterOutputStream ostream = null;
        FSDataInputStream istream = null;
        try {
            int bytes;
            istream = this.getDFS().open(this.path);
            ostream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[1024];
            while ((bytes = istream.read(buffer)) >= 0) {
                if (monitor.isCanceled()) {
                    return;
                }
                ((BufferedOutputStream)ostream).write(buffer, 0, bytes);
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                ostream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(IProgressMonitor monitor, File file) {
        int taskSize = 1024;
        monitor.setTaskName("Upload file " + this.path);
        BufferedInputStream istream = null;
        FilterOutputStream ostream = null;
        try {
            int bytes;
            istream = new BufferedInputStream(new FileInputStream(file));
            ostream = this.getDFS().create(this.path);
            byte[] buffer = new byte[1024];
            while ((bytes = istream.read(buffer)) >= 0) {
                if (monitor.isCanceled()) {
                    return;
                }
                ((DataOutputStream)ostream).write(buffer, 0, bytes);
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            ErrorMessageDialog.display((String)String.format("Unable to uploade file %s to %s", file, this.path), (String)e.getLocalizedMessage());
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (ostream != null) {
                    ostream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void refresh() {
        this.getParent().refresh();
    }

    public int computeDownloadWork() {
        return 1 + (int)(this.length / 1024L);
    }

    public IStorage getIStorage() {
        return new IStorageAdapter(this, null);
    }

    public DFSContent[] getChildren() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }
}

