/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.dfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.hadoop.eclipse.dfs.DFSContent;
import org.apache.hadoop.eclipse.dfs.DFSContentProvider;
import org.apache.hadoop.eclipse.dfs.DFSFile;
import org.apache.hadoop.eclipse.dfs.DFSMessage;
import org.apache.hadoop.eclipse.dfs.DFSPath;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class DFSFolder
extends DFSPath
implements DFSContent {
    static Logger log = Logger.getLogger(DFSFolder.class.getName());
    private DFSContent[] children;

    protected DFSFolder(DFSContentProvider provider, HadoopServer location) throws IOException {
        super(provider, location);
    }

    private DFSFolder(DFSPath parent, Path path) {
        super(parent, path);
    }

    protected void loadDFSFolderChildren() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (FileStatus status : this.getDFS().listStatus(this.getPath())) {
            if (status.isDir()) {
                list.add(new DFSFolder((DFSPath)this, status.getPath()));
                continue;
            }
            list.add(new DFSFile((DFSPath)this, status.getPath()));
        }
        this.children = list.toArray(new DFSContent[list.size()]);
    }

    public void upload(IProgressMonitor monitor, File file) throws IOException {
        if (file.isDirectory()) {
            Path filePath = new Path(this.path, file.getName());
            this.getDFS().mkdirs(filePath);
            DFSFolder newFolder = new DFSFolder((DFSPath)this, filePath);
            monitor.worked(1);
            for (File child : file.listFiles()) {
                if (monitor.isCanceled()) {
                    return;
                }
                newFolder.upload(monitor, child);
            }
        } else if (file.isFile()) {
            Path filePath = new Path(this.path, file.getName());
            DFSFile newFile = new DFSFile((DFSPath)this, filePath, file, monitor);
        }
    }

    public void downloadToLocalDirectory(IProgressMonitor monitor, File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            MessageDialog.openError(null, (String)"Download to local file system", (String)("Invalid directory location: \"" + dir + "\""));
            return;
        }
        File dfsPath = new File(this.getPath().toString());
        File destination = new File(dir, dfsPath.getName());
        if (!destination.exists() && !destination.mkdir()) {
            MessageDialog.openError(null, (String)"Download to local directory", (String)("Unable to create directory " + destination.getAbsolutePath()));
            return;
        }
        for (DFSContent childObj : this.getChildren()) {
            if (!(childObj instanceof DFSPath)) continue;
            ((DFSPath)childObj).downloadToLocalDirectory(monitor, destination);
            monitor.worked(1);
        }
    }

    public int computeDownloadWork() {
        int work = 1;
        for (DFSContent child : this.getChildren()) {
            if (!(child instanceof DFSPath)) continue;
            work += ((DFSPath)child).computeDownloadWork();
        }
        return work;
    }

    public void mkdir(String folderName) {
        try {
            this.getDFS().mkdirs(new Path(this.path, folderName));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.doRefresh();
    }

    public boolean hasChildren() {
        if (this.children == null) {
            return true;
        }
        return this.children.length > 0;
    }

    public DFSContent[] getChildren() {
        if (this.children == null) {
            new /* Unavailable Anonymous Inner Class!! */.schedule();
            return new DFSContent[]{new DFSMessage("Listing folder content...")};
        }
        return this.children;
    }

    public void refresh() {
        this.children = null;
        this.doRefresh();
    }

    public String toString() {
        return String.format("%s (%s)", super.toString(), this.getChildren().length);
    }

    static /* synthetic */ DFSContent[] access$002(DFSFolder x0, DFSContent[] x1) {
        x0.children = x1;
        return x1;
    }
}

