/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.dfs;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.eclipse.dfs.DFSContent;
import org.apache.hadoop.eclipse.dfs.DFSContentProvider;
import org.apache.hadoop.eclipse.dfs.DFSLocation;
import org.apache.hadoop.eclipse.dfs.DFSLocationsRoot;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.eclipse.servers.IHadoopServerListener;
import org.apache.hadoop.eclipse.servers.ServerRegistry;

public class DFSLocationsRoot
implements DFSContent,
IHadoopServerListener {
    private final DFSContentProvider provider;
    private Map<HadoopServer, DFSLocation> map = new HashMap();

    DFSLocationsRoot(DFSContentProvider provider) {
        this.provider = provider;
        ServerRegistry.getInstance().addListener((IHadoopServerListener)this);
        this.refresh();
    }

    public synchronized void serverChanged(HadoopServer location, int type) {
        switch (type) {
            case 2: {
                this.provider.refresh((DFSContent)this.map.get(location));
                break;
            }
            case 0: {
                DFSLocation dfsLoc = new DFSLocation(this.provider, location);
                this.map.put(location, dfsLoc);
                this.provider.refresh((DFSContent)this);
                break;
            }
            case 1: {
                this.map.remove(location);
                this.provider.refresh((DFSContent)this);
            }
        }
    }

    private synchronized void reloadLocations() {
        this.map.clear();
        for (HadoopServer location : ServerRegistry.getInstance().getServers()) {
            this.map.put(location, new DFSLocation(this.provider, location));
        }
    }

    public String toString() {
        return "DFS Locations";
    }

    public synchronized DFSContent[] getChildren() {
        return this.map.values().toArray(new DFSContent[this.map.size()]);
    }

    public boolean hasChildren() {
        return this.map.size() > 0;
    }

    public void refresh() {
        this.reloadLocations();
        this.provider.refresh((DFSContent)this);
    }

    public void disconnect() {
        1 closeThread = new /* Unavailable Anonymous Inner Class!! */;
        closeThread.start();
        try {
            closeThread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

