/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.dfs;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.hadoop.eclipse.ErrorMessageDialog;
import org.apache.hadoop.eclipse.dfs.DFSContent;
import org.apache.hadoop.eclipse.dfs.DFSContentProvider;
import org.apache.hadoop.eclipse.server.ConfProp;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public abstract class DFSPath
implements DFSContent {
    protected final DFSContentProvider provider;
    protected HadoopServer location;
    private DistributedFileSystem dfs = null;
    protected final Path path;
    protected final DFSPath parent;
    static Logger log = Logger.getLogger(DFSPath.class.getName());

    public DFSPath(DFSContentProvider provider, HadoopServer location) throws IOException {
        this.provider = provider;
        this.location = location;
        this.path = new Path("/");
        this.parent = null;
    }

    protected DFSPath(DFSPath parent, Path path) {
        this.provider = parent.provider;
        this.location = parent.location;
        this.dfs = parent.dfs;
        this.parent = parent;
        this.path = path;
    }

    protected void dispose() {
    }

    public String toString() {
        if (this.path.equals((Object)"/")) {
            return this.location.getConfProp(ConfProp.FS_DEFAULT_URI);
        }
        return this.path.getName();
    }

    public void delete() {
        try {
            this.getDFS().delete(this.path, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openWarning(null, (String)"Delete file", (String)("Unable to delete file \"" + this.path + "\"\n" + e));
        }
    }

    public DFSPath getParent() {
        return this.parent;
    }

    public abstract void refresh();

    public void doRefresh() {
        this.provider.refresh((DFSContent)this);
    }

    public abstract void downloadToLocalDirectory(IProgressMonitor var1, File var2);

    public Path getPath() {
        return this.path;
    }

    DistributedFileSystem getDFS() throws IOException {
        if (this.dfs == null) {
            FileSystem fs = this.location.getDFS();
            if (!(fs instanceof DistributedFileSystem)) {
                ErrorMessageDialog.display((String)"DFS Browser", (String)"The DFS Browser cannot browse anything else but a Distributed File System!");
                throw new IOException("DFS Browser expects a DistributedFileSystem!");
            }
            this.dfs = (DistributedFileSystem)fs;
        }
        return this.dfs;
    }

    public abstract int computeDownloadWork();
}

