/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.server;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.eclipse.server.HadoopJob;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;

public class HadoopJob {
    private final HadoopServer location;
    final JobID jobId;
    RunningJob running;
    JobStatus status;
    Counters counters;
    JobConf jobConf = null;
    boolean completed = false;
    boolean successful = false;
    boolean killed = false;
    int totalMaps;
    int totalReduces;
    int completedMaps;
    int completedReduces;
    float mapProgress;
    float reduceProgress;

    public HadoopJob(HadoopServer location, JobID id, RunningJob running, JobStatus status) {
        this.location = location;
        this.jobId = id;
        this.running = running;
        this.loadJobFile();
        this.update(status);
    }

    private void loadJobFile() {
        try {
            String jobFile = this.getJobFile();
            FileSystem fs = this.location.getDFS();
            File tmp = File.createTempFile(this.getJobID().toString(), ".xml");
            if (FileUtil.copy((FileSystem)fs, (Path)new Path(jobFile), (File)tmp, (boolean)false, (Configuration)this.location.getConfiguration())) {
                this.jobConf = new JobConf(tmp.toString());
                this.totalMaps = this.jobConf.getNumMapTasks();
                this.totalReduces = this.jobConf.getNumReduceTasks();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopJob)) {
            return false;
        }
        HadoopJob other = (HadoopJob)obj;
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals((Object)other.jobId)) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public JobState getState() {
        if (this.completed) {
            if (this.successful) {
                return JobState.SUCCEEDED;
            }
            return JobState.FAILED;
        }
        return JobState.RUNNING;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public HadoopServer getLocation() {
        return this.location;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getJobName() {
        return this.running.getJobName();
    }

    public String getJobFile() {
        return this.running.getJobFile();
    }

    public String getTrackingURL() {
        return this.running.getTrackingURL();
    }

    public String getStatus() {
        StringBuffer s = new StringBuffer();
        s.append("Maps : " + this.completedMaps + "/" + this.totalMaps);
        s.append(" (" + this.mapProgress + ")");
        s.append("  Reduces : " + this.completedReduces + "/" + this.totalReduces);
        s.append(" (" + this.reduceProgress + ")");
        return s.toString();
    }

    void update(JobStatus status) {
        this.status = status;
        try {
            this.counters = this.running.getCounters();
            this.completed = this.running.isComplete();
            this.successful = this.running.isSuccessful();
            this.mapProgress = this.running.mapProgress();
            this.reduceProgress = this.running.reduceProgress();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.completedMaps = (int)((float)this.totalMaps * this.mapProgress);
        this.completedReduces = (int)((float)this.totalReduces * this.reduceProgress);
    }

    void printCounters() {
        System.out.printf("New Job:\n", this.counters);
        for (String groupName : this.counters.getGroupNames()) {
            Counters.Group group = this.counters.getGroup(groupName);
            System.out.printf("\t%s[%s]\n", groupName, group.getDisplayName());
            for (Counters.Counter counter : group) {
                System.out.printf("\t\t%s: %s\n", counter.getDisplayName(), counter.getCounter());
            }
        }
        System.out.printf("\n", new Object[0]);
    }

    public void kill() {
        try {
            this.running.killJob();
            this.killed = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void display() {
        System.out.printf("Job id=%s, name=%s\n", this.getJobID(), this.getJobName());
        System.out.printf("Configuration file: %s\n", this.getJobID());
        System.out.printf("Tracking URL: %s\n", this.getTrackingURL());
        System.out.printf("Completion: map: %f reduce %f\n", 100.0 * (double)this.mapProgress, 100.0 * (double)this.reduceProgress);
        System.out.println("Job total maps = " + this.totalMaps);
        System.out.println("Job completed maps = " + this.completedMaps);
        System.out.println("Map percentage complete = " + this.mapProgress);
        System.out.println("Job total reduces = " + this.totalReduces);
        System.out.println("Job completed reduces = " + this.completedReduces);
        System.out.println("Reduce percentage complete = " + this.reduceProgress);
        System.out.flush();
    }
}

