/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.eclipse.server;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.eclipse.server.ConfProp;
import org.apache.hadoop.eclipse.server.HadoopJob;
import org.apache.hadoop.eclipse.server.HadoopServer;
import org.apache.hadoop.eclipse.server.IJobListener;
import org.apache.hadoop.eclipse.server.JarModule;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HadoopServer {
    protected static final long STATUS_OBSERVATION_DELAY = 1500L;
    static Logger log = Logger.getLogger(HadoopServer.class.getName());
    private Configuration conf;
    private Set<IJobListener> jobListeners = new HashSet();
    private transient Map<JobID, HadoopJob> runningJobs = Collections.synchronizedMap(new TreeMap());
    private LocationStatusUpdater statusUpdater;
    private transient String state = "";

    public HadoopServer() {
        this.conf = new Configuration();
        log.info(" load configuration ..." + this.conf.toString());
        this.addPluginConfigDefaultProperties();
    }

    public HadoopServer(File file) throws ParserConfigurationException, SAXException, IOException {
        this.conf = new Configuration();
        this.addPluginConfigDefaultProperties();
        this.loadFromXML(file);
    }

    public HadoopServer(HadoopServer existing) {
        this();
        this.load(existing);
    }

    public void addJobListener(IJobListener l) {
        this.jobListeners.add(l);
    }

    public void dispose() {
    }

    public Collection<HadoopJob> getJobs() {
        this.startStatusUpdater();
        return this.runningJobs.values();
    }

    public void purgeJob(HadoopJob job) {
        this.runningJobs.remove(job.getJobID());
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public String getConfProp(ConfProp prop) {
        return prop.get(this.conf);
    }

    public String getConfProp(String propName) {
        return this.conf.get(propName);
    }

    public String getLocationName() {
        return ConfProp.PI_LOCATION_NAME.get(this.conf);
    }

    public String getMasterHostName() {
        return this.getConfProp(ConfProp.PI_JOB_TRACKER_HOST);
    }

    public String getState() {
        return this.state;
    }

    public void load(HadoopServer existing) {
        this.conf = new Configuration(existing.conf);
    }

    public boolean loadFromXML(File file) throws ParserConfigurationException, SAXException, IOException {
        Configuration newConf = new Configuration(this.conf);
        log.info("loadxml from file: " + file.toString());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(file);
        Element root = document.getDocumentElement();
        if (!"configuration".equals(root.getTagName())) {
            return false;
        }
        NodeList props = root.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node propNode = props.item(i);
            if (!(propNode instanceof Element)) continue;
            Element prop = (Element)propNode;
            if (!"property".equals(prop.getTagName())) {
                return false;
            }
            NodeList fields = prop.getChildNodes();
            String attr = null;
            String value = null;
            for (int j = 0; j < fields.getLength(); ++j) {
                Node fieldNode = fields.item(j);
                if (!(fieldNode instanceof Element)) continue;
                Element field = (Element)fieldNode;
                if ("name".equals(field.getTagName())) {
                    attr = ((Text)field.getFirstChild()).getData();
                }
                if (!"value".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                value = ((Text)field.getFirstChild()).getData();
            }
            if (attr == null || value == null) continue;
            newConf.set(attr, value);
        }
        this.conf = newConf;
        return true;
    }

    public void setConfProp(ConfProp prop, String propValue) {
        prop.set(this.conf, propValue);
    }

    public void setConfProp(String propName, String propValue) {
        this.conf.set(propName, propValue);
    }

    public void setLocationName(String newName) {
        ConfProp.PI_LOCATION_NAME.set(this.conf, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSettingsToFile(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.conf.writeXml((OutputStream)fos);
            fos.close();
            fos = null;
        }
        finally {
            IOUtils.closeStream((Closeable)fos);
        }
    }

    public String toString() {
        return this.getLocationName();
    }

    private void addPluginConfigDefaultProperties() {
        for (ConfProp prop : ConfProp.values()) {
            if (this.conf.get(prop.name) != null) continue;
            log.info("add pro:" + prop.name);
            this.conf.set(prop.name, prop.defVal);
        }
    }

    private synchronized void startStatusUpdater() {
        if (this.statusUpdater == null) {
            this.statusUpdater = new LocationStatusUpdater(this);
            this.statusUpdater.schedule();
        }
    }

    public FileSystem getDFS() throws IOException {
        return FileSystem.get((Configuration)this.conf);
    }

    public JobClient getJobClient() throws IOException {
        JobConf jconf = new JobConf(this.conf);
        return new JobClient(jconf);
    }

    protected void fireJarPublishDone(JarModule jar) {
        for (IJobListener listener : this.jobListeners) {
            listener.publishDone(jar);
        }
    }

    protected void fireJarPublishStart(JarModule jar) {
        for (IJobListener listener : this.jobListeners) {
            listener.publishStart(jar);
        }
    }

    protected void fireJobAdded(HadoopJob job) {
        for (IJobListener listener : this.jobListeners) {
            listener.jobAdded(job);
        }
    }

    protected void fireJobRemoved(HadoopJob job) {
        for (IJobListener listener : this.jobListeners) {
            listener.jobRemoved(job);
        }
    }

    protected void fireJobChanged(HadoopJob job) {
        for (IJobListener listener : this.jobListeners) {
            listener.jobChanged(job);
        }
    }

    static /* synthetic */ Map access$000(HadoopServer x0) {
        return x0.runningJobs;
    }
}

